/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.model.CommerceSubscriptionCycleEntry;
import com.liferay.commerce.model.CommerceSubscriptionCycleEntryModel;
import com.liferay.commerce.model.CommerceSubscriptionCycleEntrySoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.exportimport.kernel.lar.StagedModelType;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceSubscriptionCycleEntry service. Represents a row in the &quot;CSubscriptionCycleEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceSubscriptionCycleEntryModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceSubscriptionCycleEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceSubscriptionCycleEntryImpl
 * @see CommerceSubscriptionCycleEntry
 * @see CommerceSubscriptionCycleEntryModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceSubscriptionCycleEntryModelImpl extends BaseModelImpl<CommerceSubscriptionCycleEntry>
	implements CommerceSubscriptionCycleEntryModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce subscription cycle entry model instance should use the {@link CommerceSubscriptionCycleEntry} interface instead.
	 */
	public static final String TABLE_NAME = "CSubscriptionCycleEntry";
	public static final Object[][] TABLE_COLUMNS = {
			{ "uuid_", Types.VARCHAR },
			{ "CSubscriptionCycleEntryId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "commerceSubscriptionEntryId", Types.BIGINT },
			{ "commerceOrderItemId", Types.BIGINT },
			{ "renew", Types.BOOLEAN }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CSubscriptionCycleEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceSubscriptionEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("renew", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE = "create table CSubscriptionCycleEntry (uuid_ VARCHAR(75) null,CSubscriptionCycleEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceSubscriptionEntryId LONG,commerceOrderItemId LONG,renew BOOLEAN)";
	public static final String TABLE_SQL_DROP = "drop table CSubscriptionCycleEntry";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceSubscriptionCycleEntry.createDate DESC";
	public static final String ORDER_BY_SQL = " ORDER BY CSubscriptionCycleEntry.createDate DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceSubscriptionCycleEntry"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceSubscriptionCycleEntry"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceSubscriptionCycleEntry"),
			true);
	public static final long COMMERCEORDERITEMID_COLUMN_BITMASK = 1L;
	public static final long COMMERCESUBSCRIPTIONENTRYID_COLUMN_BITMASK = 2L;
	public static final long COMPANYID_COLUMN_BITMASK = 4L;
	public static final long GROUPID_COLUMN_BITMASK = 8L;
	public static final long UUID_COLUMN_BITMASK = 16L;
	public static final long CREATEDATE_COLUMN_BITMASK = 32L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceSubscriptionCycleEntry toModel(
		CommerceSubscriptionCycleEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceSubscriptionCycleEntry model = new CommerceSubscriptionCycleEntryImpl();

		model.setUuid(soapModel.getUuid());
		model.setCommerceSubscriptionCycleEntryId(soapModel.getCommerceSubscriptionCycleEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceSubscriptionEntryId(soapModel.getCommerceSubscriptionEntryId());
		model.setCommerceOrderItemId(soapModel.getCommerceOrderItemId());
		model.setRenew(soapModel.isRenew());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceSubscriptionCycleEntry> toModels(
		CommerceSubscriptionCycleEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceSubscriptionCycleEntry> models = new ArrayList<CommerceSubscriptionCycleEntry>(soapModels.length);

		for (CommerceSubscriptionCycleEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.model.CommerceSubscriptionCycleEntry"));

	public CommerceSubscriptionCycleEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceSubscriptionCycleEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceSubscriptionCycleEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceSubscriptionCycleEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceSubscriptionCycleEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceSubscriptionCycleEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("commerceSubscriptionCycleEntryId",
			getCommerceSubscriptionCycleEntryId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceSubscriptionEntryId",
			getCommerceSubscriptionEntryId());
		attributes.put("commerceOrderItemId", getCommerceOrderItemId());
		attributes.put("renew", isRenew());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		Long commerceSubscriptionCycleEntryId = (Long)attributes.get(
				"commerceSubscriptionCycleEntryId");

		if (commerceSubscriptionCycleEntryId != null) {
			setCommerceSubscriptionCycleEntryId(commerceSubscriptionCycleEntryId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceSubscriptionEntryId = (Long)attributes.get(
				"commerceSubscriptionEntryId");

		if (commerceSubscriptionEntryId != null) {
			setCommerceSubscriptionEntryId(commerceSubscriptionEntryId);
		}

		Long commerceOrderItemId = (Long)attributes.get("commerceOrderItemId");

		if (commerceOrderItemId != null) {
			setCommerceOrderItemId(commerceOrderItemId);
		}

		Boolean renew = (Boolean)attributes.get("renew");

		if (renew != null) {
			setRenew(renew);
		}
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getCommerceSubscriptionCycleEntryId() {
		return _commerceSubscriptionCycleEntryId;
	}

	@Override
	public void setCommerceSubscriptionCycleEntryId(
		long commerceSubscriptionCycleEntryId) {
		_commerceSubscriptionCycleEntryId = commerceSubscriptionCycleEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceSubscriptionEntryId() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setCommerceSubscriptionEntryId(long commerceSubscriptionEntryId) {
		_columnBitmask |= COMMERCESUBSCRIPTIONENTRYID_COLUMN_BITMASK;

		if (!_setOriginalCommerceSubscriptionEntryId) {
			_setOriginalCommerceSubscriptionEntryId = true;

			_originalCommerceSubscriptionEntryId = _commerceSubscriptionEntryId;
		}

		_commerceSubscriptionEntryId = commerceSubscriptionEntryId;
	}

	public long getOriginalCommerceSubscriptionEntryId() {
		return _originalCommerceSubscriptionEntryId;
	}

	@JSON
	@Override
	public long getCommerceOrderItemId() {
		return _commerceOrderItemId;
	}

	@Override
	public void setCommerceOrderItemId(long commerceOrderItemId) {
		_columnBitmask |= COMMERCEORDERITEMID_COLUMN_BITMASK;

		if (!_setOriginalCommerceOrderItemId) {
			_setOriginalCommerceOrderItemId = true;

			_originalCommerceOrderItemId = _commerceOrderItemId;
		}

		_commerceOrderItemId = commerceOrderItemId;
	}

	public long getOriginalCommerceOrderItemId() {
		return _originalCommerceOrderItemId;
	}

	@JSON
	@Override
	public boolean getRenew() {
		return _renew;
	}

	@JSON
	@Override
	public boolean isRenew() {
		return _renew;
	}

	@Override
	public void setRenew(boolean renew) {
		_renew = renew;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(PortalUtil.getClassNameId(
				CommerceSubscriptionCycleEntry.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceSubscriptionCycleEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceSubscriptionCycleEntry toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceSubscriptionCycleEntry)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceSubscriptionCycleEntryImpl commerceSubscriptionCycleEntryImpl = new CommerceSubscriptionCycleEntryImpl();

		commerceSubscriptionCycleEntryImpl.setUuid(getUuid());
		commerceSubscriptionCycleEntryImpl.setCommerceSubscriptionCycleEntryId(getCommerceSubscriptionCycleEntryId());
		commerceSubscriptionCycleEntryImpl.setGroupId(getGroupId());
		commerceSubscriptionCycleEntryImpl.setCompanyId(getCompanyId());
		commerceSubscriptionCycleEntryImpl.setUserId(getUserId());
		commerceSubscriptionCycleEntryImpl.setUserName(getUserName());
		commerceSubscriptionCycleEntryImpl.setCreateDate(getCreateDate());
		commerceSubscriptionCycleEntryImpl.setModifiedDate(getModifiedDate());
		commerceSubscriptionCycleEntryImpl.setCommerceSubscriptionEntryId(getCommerceSubscriptionEntryId());
		commerceSubscriptionCycleEntryImpl.setCommerceOrderItemId(getCommerceOrderItemId());
		commerceSubscriptionCycleEntryImpl.setRenew(isRenew());

		commerceSubscriptionCycleEntryImpl.resetOriginalValues();

		return commerceSubscriptionCycleEntryImpl;
	}

	@Override
	public int compareTo(
		CommerceSubscriptionCycleEntry commerceSubscriptionCycleEntry) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(),
				commerceSubscriptionCycleEntry.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceSubscriptionCycleEntry)) {
			return false;
		}

		CommerceSubscriptionCycleEntry commerceSubscriptionCycleEntry = (CommerceSubscriptionCycleEntry)obj;

		long primaryKey = commerceSubscriptionCycleEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceSubscriptionCycleEntryModelImpl commerceSubscriptionCycleEntryModelImpl =
			this;

		commerceSubscriptionCycleEntryModelImpl._originalUuid = commerceSubscriptionCycleEntryModelImpl._uuid;

		commerceSubscriptionCycleEntryModelImpl._originalGroupId = commerceSubscriptionCycleEntryModelImpl._groupId;

		commerceSubscriptionCycleEntryModelImpl._setOriginalGroupId = false;

		commerceSubscriptionCycleEntryModelImpl._originalCompanyId = commerceSubscriptionCycleEntryModelImpl._companyId;

		commerceSubscriptionCycleEntryModelImpl._setOriginalCompanyId = false;

		commerceSubscriptionCycleEntryModelImpl._setModifiedDate = false;

		commerceSubscriptionCycleEntryModelImpl._originalCommerceSubscriptionEntryId = commerceSubscriptionCycleEntryModelImpl._commerceSubscriptionEntryId;

		commerceSubscriptionCycleEntryModelImpl._setOriginalCommerceSubscriptionEntryId = false;

		commerceSubscriptionCycleEntryModelImpl._originalCommerceOrderItemId = commerceSubscriptionCycleEntryModelImpl._commerceOrderItemId;

		commerceSubscriptionCycleEntryModelImpl._setOriginalCommerceOrderItemId = false;

		commerceSubscriptionCycleEntryModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceSubscriptionCycleEntry> toCacheModel() {
		CommerceSubscriptionCycleEntryCacheModel commerceSubscriptionCycleEntryCacheModel =
			new CommerceSubscriptionCycleEntryCacheModel();

		commerceSubscriptionCycleEntryCacheModel.uuid = getUuid();

		String uuid = commerceSubscriptionCycleEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceSubscriptionCycleEntryCacheModel.uuid = null;
		}

		commerceSubscriptionCycleEntryCacheModel.commerceSubscriptionCycleEntryId = getCommerceSubscriptionCycleEntryId();

		commerceSubscriptionCycleEntryCacheModel.groupId = getGroupId();

		commerceSubscriptionCycleEntryCacheModel.companyId = getCompanyId();

		commerceSubscriptionCycleEntryCacheModel.userId = getUserId();

		commerceSubscriptionCycleEntryCacheModel.userName = getUserName();

		String userName = commerceSubscriptionCycleEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceSubscriptionCycleEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceSubscriptionCycleEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceSubscriptionCycleEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceSubscriptionCycleEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceSubscriptionCycleEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceSubscriptionCycleEntryCacheModel.commerceSubscriptionEntryId = getCommerceSubscriptionEntryId();

		commerceSubscriptionCycleEntryCacheModel.commerceOrderItemId = getCommerceOrderItemId();

		commerceSubscriptionCycleEntryCacheModel.renew = isRenew();

		return commerceSubscriptionCycleEntryCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(23);

		sb.append("{uuid=");
		sb.append(getUuid());
		sb.append(", commerceSubscriptionCycleEntryId=");
		sb.append(getCommerceSubscriptionCycleEntryId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", commerceSubscriptionEntryId=");
		sb.append(getCommerceSubscriptionEntryId());
		sb.append(", commerceOrderItemId=");
		sb.append(getCommerceOrderItemId());
		sb.append(", renew=");
		sb.append(isRenew());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(37);

		sb.append("<model><model-name>");
		sb.append("com.liferay.commerce.model.CommerceSubscriptionCycleEntry");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>uuid</column-name><column-value><![CDATA[");
		sb.append(getUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceSubscriptionCycleEntryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceSubscriptionCycleEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceSubscriptionEntryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceSubscriptionEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceOrderItemId</column-name><column-value><![CDATA[");
		sb.append(getCommerceOrderItemId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>renew</column-name><column-value><![CDATA[");
		sb.append(isRenew());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceSubscriptionCycleEntry.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceSubscriptionCycleEntry.class, ModelWrapper.class
		};
	private String _uuid;
	private String _originalUuid;
	private long _commerceSubscriptionCycleEntryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceSubscriptionEntryId;
	private long _originalCommerceSubscriptionEntryId;
	private boolean _setOriginalCommerceSubscriptionEntryId;
	private long _commerceOrderItemId;
	private long _originalCommerceOrderItemId;
	private boolean _setOriginalCommerceOrderItemId;
	private boolean _renew;
	private long _columnBitmask;
	private CommerceSubscriptionCycleEntry _escapedModel;
}