/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.DuplicateCommerceOrderTypeRelException;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeRel;
import com.liferay.commerce.model.CommerceOrderTypeRelTable;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelTable;
import com.liferay.commerce.service.base.CommerceOrderTypeRelLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceOrderTypeRelLocalServiceImpl
extends CommerceOrderTypeRelLocalServiceBaseImpl {
    @ServiceReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public CommerceOrderTypeRel addCommerceOrderTypeRel(long userId, String className, long classPK, long commerceOrderTypeId, ServiceContext serviceContext) throws PortalException {
        this._validate(className, classPK, commerceOrderTypeId);
        CommerceOrderTypeRel commerceOrderTypeRel = this.commerceOrderTypeRelPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        commerceOrderTypeRel.setCompanyId(user.getCompanyId());
        commerceOrderTypeRel.setUserId(user.getUserId());
        commerceOrderTypeRel.setUserName(user.getFullName());
        commerceOrderTypeRel.setClassNameId(this._classNameLocalService.getClassNameId(className));
        commerceOrderTypeRel.setClassPK(classPK);
        commerceOrderTypeRel.setCommerceOrderTypeId(commerceOrderTypeId);
        commerceOrderTypeRel.setExpandoBridgeAttributes(serviceContext);
        commerceOrderTypeRel = (CommerceOrderTypeRel)this.commerceOrderTypeRelPersistence.update((BaseModel)commerceOrderTypeRel);
        this._reindexCommerceOrderType(commerceOrderTypeId);
        return commerceOrderTypeRel;
    }

    @Override
    public CommerceOrderTypeRel deleteCommerceOrderTypeRel(long commerceOrderTypeRelId) throws PortalException {
        CommerceOrderTypeRel commerceOrderTypeRel = this.commerceOrderTypeRelPersistence.findByPrimaryKey(commerceOrderTypeRelId);
        this.commerceOrderTypeRelPersistence.remove((BaseModel)commerceOrderTypeRel);
        this._reindexCommerceOrderType(commerceOrderTypeRel.getCommerceOrderTypeId());
        return commerceOrderTypeRel;
    }

    public void deleteCommerceOrderTypeRels(long commerceOrderTypeId) throws PortalException {
        List commerceOrderTypeRels = this.commerceOrderTypeRelPersistence.findByCommerceOrderTypeId(commerceOrderTypeId);
        for (CommerceOrderTypeRel commerceOrderTypeRel : commerceOrderTypeRels) {
            this.commerceOrderTypeRelLocalService.deleteCommerceOrderTypeRel(commerceOrderTypeRel.getCommerceOrderTypeRelId());
        }
    }

    public void deleteCommerceOrderTypeRels(String className, long commerceOrderTypeId) throws PortalException {
        List commerceOrderTypeRels = this.commerceOrderTypeRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), commerceOrderTypeId);
        for (CommerceOrderTypeRel commerceOrderTypeRel : commerceOrderTypeRels) {
            this.commerceOrderTypeRelLocalService.deleteCommerceOrderTypeRel(commerceOrderTypeRel.getCommerceOrderTypeRelId());
        }
    }

    public List<CommerceOrderTypeRel> getCommerceOrderTypeCommerceChannelRels(long commerceOrderTypeId, String keywords, int start, int end) throws PortalException {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceOrderTypeRelTable.INSTANCE), (Table)CommerceChannelTable.INSTANCE, CommerceChannelTable.INSTANCE.commerceChannelId.eq((Expression)CommerceOrderTypeRelTable.INSTANCE.classPK), commerceOrderTypeId, CommerceChannel.class.getName(), keywords, (Expression<String>)CommerceChannelTable.INSTANCE.name).limit(start, end));
    }

    public int getCommerceOrderTypeCommerceChannelRelsCount(long commerceOrderTypeId, String keywords) throws PortalException {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceOrderTypeRelTable.INSTANCE.commerceOrderTypeRelId), (Table)CommerceChannelTable.INSTANCE, CommerceChannelTable.INSTANCE.commerceChannelId.eq((Expression)CommerceOrderTypeRelTable.INSTANCE.classPK), commerceOrderTypeId, CommerceChannel.class.getName(), keywords, (Expression<String>)CommerceChannelTable.INSTANCE.name));
    }

    @Override
    public CommerceOrderTypeRel getCommerceOrderTypeRel(long commerceOrderTypeRelId) throws PortalException {
        return this.commerceOrderTypeRelPersistence.findByPrimaryKey(commerceOrderTypeRelId);
    }

    public List<CommerceOrderTypeRel> getCommerceOrderTypeRels(String className, long classPK, int start, int end, OrderByComparator<CommerceOrderTypeRel> orderByComparator) {
        return this.commerceOrderTypeRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public int getCommerceOrderTypeRelsCount(String className, long classPK) {
        return this.commerceOrderTypeRelPersistence.countByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Table innerJoinTable, Predicate innerJoinPredicate, Long commerceOrderTypeId, String className, String keywords, Expression<String> keywordsPredicateExpression) throws PortalException {
        JoinStep joinStep = fromStep.from((Table)CommerceOrderTypeRelTable.INSTANCE).innerJoinON((Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceOrderTypeRelTable.INSTANCE.commerceOrderTypeId)).innerJoinON(innerJoinTable, innerJoinPredicate);
        return joinStep.where(() -> {
            Predicate predicate = CommerceOrderTypeRelTable.INSTANCE.commerceOrderTypeId.eq((Object)commerceOrderTypeId).and((Expression)CommerceOrderTypeRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className)));
            if (Validator.isNotNull((String)keywords)) {
                predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)keywordsPredicateExpression), this._customSQL.keywords(keywords, true))));
            }
            return predicate;
        });
    }

    private void _reindexCommerceOrderType(long commerceOrderTypeId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceOrderType.class);
        indexer.reindex(CommerceOrderType.class.getName(), commerceOrderTypeId);
    }

    private void _validate(String className, long classPK, long commerceOrderTypeId) throws PortalException {
        int commerceOrderTypeRelsCount = this.commerceOrderTypeRelPersistence.countByC_C_C(this._classNameLocalService.getClassNameId(className), classPK, commerceOrderTypeId);
        if (commerceOrderTypeRelsCount > 0) {
            throw new DuplicateCommerceOrderTypeRelException();
        }
    }
}

