/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.configuration.CommerceOrderFieldsConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.exception.CommerceDiscountCouponCodeException;
import com.liferay.commerce.discount.exception.CommerceDiscountLimitationTimesException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountUsageEntryLocalService;
import com.liferay.commerce.discount.validator.helper.CommerceDiscountValidatorHelper;
import com.liferay.commerce.exception.CommerceOrderAccountLimitException;
import com.liferay.commerce.exception.CommerceOrderBillingAddressException;
import com.liferay.commerce.exception.CommerceOrderDateException;
import com.liferay.commerce.exception.CommerceOrderPaymentMethodException;
import com.liferay.commerce.exception.CommerceOrderPurchaseOrderNumberException;
import com.liferay.commerce.exception.CommerceOrderRequestedDeliveryDateException;
import com.liferay.commerce.exception.CommerceOrderShippingAddressException;
import com.liferay.commerce.exception.CommerceOrderShippingMethodException;
import com.liferay.commerce.exception.CommerceOrderStatusException;
import com.liferay.commerce.exception.CommercePaymentEngineException;
import com.liferay.commerce.exception.GuestCartMaxAllowedException;
import com.liferay.commerce.internal.order.comparator.CommerceOrderModifiedDateComparator;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOption;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.commerce.search.facet.NegatableMultiValueFacet;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderNoteLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.service.base.CommerceOrderLocalServiceBaseImpl;
import com.liferay.commerce.service.persistence.CommerceOrderItemPersistence;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryLocalService;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CommerceOrderLocalServiceImpl
extends CommerceOrderLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderLocalServiceImpl.class);
    @BeanReference(type=CommerceAddressLocalService.class)
    private CommerceAddressLocalService _commerceAddressLocalService;
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;
    @ServiceReference(type=CommerceCurrencyLocalService.class)
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @ServiceReference(type=CommerceDiscountLocalService.class)
    private CommerceDiscountLocalService _commerceDiscountLocalService;
    @ServiceReference(type=CommerceDiscountUsageEntryLocalService.class)
    private CommerceDiscountUsageEntryLocalService _commerceDiscountUsageEntryLocalService;
    @ServiceReference(type=CommerceDiscountValidatorHelper.class)
    private CommerceDiscountValidatorHelper _commerceDiscountValidatorHelper;
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @BeanReference(type=CommerceOrderItemLocalService.class)
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @BeanReference(type=CommerceOrderItemPersistence.class)
    private CommerceOrderItemPersistence _commerceOrderItemPersistence;
    @BeanReference(type=CommerceOrderNoteLocalService.class)
    private CommerceOrderNoteLocalService _commerceOrderNoteLocalService;
    @BeanReference(type=CommerceOrderPaymentLocalService.class)
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @ServiceReference(type=CommerceOrderPriceCalculation.class)
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @BeanReference(type=CommerceOrderTypeLocalService.class)
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;
    @ServiceReference(type=CommerceShippingEngineRegistry.class)
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @ServiceReference(type=CommerceShippingHelper.class)
    private CommerceShippingHelper _commerceShippingHelper;
    @BeanReference(type=CommerceShippingMethodLocalService.class)
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @ServiceReference(type=CommerceTermEntryLocalService.class)
    private CommerceTermEntryLocalService _commerceTermEntryLocalService;
    @ServiceReference(type=ConfigurationProvider.class)
    private ConfigurationProvider _configurationProvider;
    @ServiceReference(type=DTOConverterRegistry.class)
    private DTOConverterRegistry _dtoConverterRegistry;
    @ServiceReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @ServiceReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @ServiceReference(type=JsonHelper.class)
    private JsonHelper _jsonHelper;
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @ServiceReference(type=WorkflowDefinitionLinkLocalService.class)
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    @ServiceReference(type=WorkflowInstanceLinkLocalService.class)
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @ServiceReference(type=WorkflowTaskManager.class)
    private WorkflowTaskManager _workflowTaskManager;

    @Deprecated
    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId) throws PortalException {
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, 0L);
    }

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId) throws PortalException {
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, 0L, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, 0L, 0L, null, 0, 0, 0, 0, 0, 2, 1, null, BigDecimal.ZERO, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, new ServiceContext());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder addCommerceOrder(long userId, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String commercePaymentMethodKey, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, ServiceContext serviceContext) throws PortalException {
        CommerceCurrency commerceCurrency;
        if (userId == 0L) {
            Group group = this._groupLocalService.getGroup(groupId);
            User defaultUser = this._userLocalService.getDefaultUser(group.getCompanyId());
            userId = defaultUser.getUserId();
        }
        serviceContext.setUserId(userId);
        User user = this._userLocalService.getUser(userId);
        if (this.hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        serviceContext.setScopeGroupId(groupId);
        this.validateAccountOrdersLimit(groupId, commerceAccountId);
        this.validateGuestOrders();
        if (commerceCurrencyId <= 0L && (commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(serviceContext.getCompanyId())) != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        if (commerceOrderTypeId <= 0L) {
            CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
            List commerceOrderTypes = this._commerceOrderTypeLocalService.getCommerceOrderTypes(user.getCompanyId(), CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), true, 0, 1);
            if (!commerceOrderTypes.isEmpty()) {
                CommerceOrderType commerceOrderType = (CommerceOrderType)commerceOrderTypes.get(0);
                commerceOrderTypeId = commerceOrderType.getCommerceOrderTypeId();
            }
        }
        long commerceOrderId = this.counterLocalService.increment();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.create(commerceOrderId);
        commerceOrder.setGroupId(groupId);
        commerceOrder.setCompanyId(user.getCompanyId());
        commerceOrder.setUserId(userId);
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setCommerceAccountId(commerceAccountId);
        commerceOrder.setCommerceCurrencyId(commerceCurrencyId);
        commerceOrder.setCommerceOrderTypeId(commerceOrderTypeId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setShippingOptionName(shippingOptionName);
        this._setCommerceOrderPrices(commerceOrder, shippingAmount, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, null, true);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, null, false);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, null, true);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, null, false);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, null, true);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, null, false);
        commerceOrder.setManuallyAdjusted(false);
        Date orderDate = PortalUtil.getDate((int)orderDateMonth, (int)orderDateDay, (int)orderDateYear, (int)orderDateHour, (int)orderDateMinute, (TimeZone)user.getTimeZone(), null);
        if (orderDate != null) {
            commerceOrder.setOrderDate(orderDate);
        } else {
            commerceOrder.setOrderDate(new Date());
        }
        commerceOrder.setOrderStatus(orderStatus);
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setStatus(2);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(null));
        commerceOrder.setExpandoBridgeAttributes(serviceContext);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getScopeGroupId(), (long)userId, (String)CommerceOrder.class.getName(), (long)commerceOrder.getCommerceOrderId(), (Object)commerceOrder, (ServiceContext)serviceContext, new HashMap());
    }

    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long userId, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceOrder = this.commerceOrderPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (commerceOrder != null) {
            commerceOrder = this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrder.getCommerceOrderId(), billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, commerceOrder.getTotalDiscountAmount(), totalWithTaxAmount, commerceContext);
            commerceOrder = this.commerceOrderLocalService.updatePaymentStatus(userId, commerceOrder.getCommerceOrderId(), paymentStatus);
            User user = this._userLocalService.getUser(serviceContext.getUserId());
            Date orderDate = PortalUtil.getDate((int)orderDateMonth, (int)orderDateDay, (int)orderDateYear, (int)orderDateHour, (int)orderDateMinute, (TimeZone)user.getTimeZone(), null);
            if (orderDate != null) {
                commerceOrder.setOrderDate(orderDate);
            }
            commerceOrder.setOrderStatus(orderStatus);
            return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        }
        commerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, commercePaymentMethodKey, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, serviceContext);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Deprecated
    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, int paymentStatus, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, String advanceStatus, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderLocalService.addOrUpdateCommerceOrder(externalReferenceCode, userId, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, 0L, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        boolean hasDiscounts = false;
        int count = this._commerceDiscountLocalService.getActiveCommerceDiscountsCount(commerceOrder.getCompanyId(), couponCode, true);
        if (count == 0) {
            hasDiscounts = true;
        }
        if (hasDiscounts && Validator.isNotNull((String)couponCode)) {
            throw new CommerceDiscountCouponCodeException();
        }
        if (Validator.isNotNull((String)couponCode)) {
            CommerceDiscount commerceDiscount = this._commerceDiscountLocalService.getActiveCommerceDiscount(commerceOrder.getCompanyId(), couponCode, true);
            this._commerceDiscountValidatorHelper.checkValid(commerceContext, commerceDiscount, new String[0]);
            if (!this._commerceDiscountUsageEntryLocalService.validateDiscountLimitationUsage(CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), commerceDiscount.getCommerceDiscountId())) {
                throw new CommerceDiscountLimitationTimesException();
            }
        }
        commerceOrder.setCouponCode(couponCode);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return this.commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceOrder deleteCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        this._commerceOrderItemLocalService.deleteCommerceOrderItems(commerceOrder.getCommerceOrderId());
        this._commerceOrderNoteLocalService.deleteCommerceOrderNotes(commerceOrder.getCommerceOrderId());
        this._commerceOrderPaymentLocalService.deleteCommerceOrderPayments(commerceOrder.getCommerceOrderId());
        this._commerceAddressLocalService.deleteCommerceAddresses(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId());
        this.commerceOrderPersistence.remove((BaseModel)commerceOrder);
        this._expandoRowLocalService.deleteRows(commerceOrder.getCommerceOrderId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceOrder.getCompanyId(), commerceOrder.getScopeGroupId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId());
        return commerceOrder;
    }

    @Override
    public CommerceOrder deleteCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
    }

    public void deleteCommerceOrders(long groupId) throws PortalException {
        List commerceOrders = this.commerceOrderPersistence.findByGroupId(groupId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
        }
    }

    @Deprecated
    public void deleteCommerceOrders(long userId, Date date, int status) {
        this.commerceOrderPersistence.removeByU_LtC_O(userId, date, status);
    }

    public void deleteCommerceOrdersByAccountId(long commerceAccountId, Date date, int status) {
        this.commerceOrderPersistence.removeByC_LtC_O(date, commerceAccountId, status);
    }

    public CommerceOrder executeWorkflowTransition(long userId, long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        long companyId = commerceOrder.getCompanyId();
        WorkflowTask workflowTask = this._workflowTaskManager.getWorkflowTask(workflowTaskId);
        if (!workflowTask.isAssignedToSingleUser()) {
            workflowTask = this._workflowTaskManager.assignWorkflowTaskToUser(companyId, userId, workflowTask.getWorkflowTaskId(), userId, comment, null, null);
        }
        this._workflowTaskManager.completeWorkflowTask(companyId, userId, workflowTask.getWorkflowTaskId(), transitionName, comment, null, true);
        return commerceOrder;
    }

    public CommerceOrder fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceOrderPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) {
        return this.commerceOrderPersistence.fetchByG_C_O_First(groupId, commerceAccountId, orderStatus, (OrderByComparator)new CommerceOrderModifiedDateComparator());
    }

    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) {
        return this.commerceOrderFinder.fetchByG_U_C_O_S_First(groupId, userId, commerceAccountId, orderStatus);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) {
        return this.commerceOrderFinder.findByG_O(groupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderFinder.findByG_O(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByG_C(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, start, end);
        BaseModelSearchResult baseModelSearchResult = this.commerceOrderLocalService.searchCommerceOrders(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, String commercePaymentMethodKey) {
        return this.commerceOrderPersistence.findByG_CP(groupId, commercePaymentMethodKey);
    }

    public List<CommerceOrder> getCommerceOrdersByBillingAddress(long billingAddressId) {
        return this.commerceOrderPersistence.findByBillingAddressId(billingAddressId);
    }

    public List<CommerceOrder> getCommerceOrdersByCommerceAccountId(long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByCommerceAccountId(commerceAccountId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrdersByShippingAddress(long shippingAddressId) {
        return this.commerceOrderPersistence.findByShippingAddressId(shippingAddressId);
    }

    public int getCommerceOrdersCount(long groupId) {
        return this.commerceOrderPersistence.countByGroupId(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long commerceAccountId) {
        return this.commerceOrderPersistence.countByG_C(groupId, commerceAccountId);
    }

    public long getCommerceOrdersCount(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, -1, -1);
        return this.commerceOrderLocalService.searchCommerceOrdersCount(searchContext);
    }

    public int getCommerceOrdersCountByCommerceAccountId(long commerceAccountId) {
        return this.commerceOrderPersistence.countByCommerceAccountId(commerceAccountId);
    }

    public List<CommerceOrder> getShippedCommerceOrdersByCommerceShipmentId(long commerceShipmentId, int start, int end) {
        return this.commerceOrderFinder.getShippedCommerceOrdersByCommerceShipmentId(commerceShipmentId, start, end);
    }

    @Deprecated
    public List<CommerceOrder> getUserCommerceOrders(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords, int start, int end) {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false, start, end);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return Collections.emptyList();
        }
    }

    @Deprecated
    public int getUserCommerceOrdersCount(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords) {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return 0;
        }
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List guestCommerceOrderItems = this._commerceOrderItemPersistence.findByCommerceOrderId(guestCommerceOrderId);
        for (CommerceOrderItem guestCommerceOrderItem : guestCommerceOrderItems) {
            List userCommerceOrderItems = this._commerceOrderItemPersistence.findByC_CPI(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId());
            if (!userCommerceOrderItems.isEmpty()) {
                boolean found = false;
                for (CommerceOrderItem userCommerceOrderItem : userCommerceOrderItems) {
                    if (!Objects.equals(guestCommerceOrderItem.getJson(), userCommerceOrderItem.getJson())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            this._commerceOrderItemLocalService.addCommerceOrderItem(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId(), guestCommerceOrderItem.getJson(), guestCommerceOrderItem.getQuantity(), guestCommerceOrderItem.getShippedQuantity(), commerceContext, serviceContext);
        }
        this.commerceOrderLocalService.deleteCommerceOrder(guestCommerceOrderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (commerceOrder.getOrderStatus() != 2 || commerceOrder.isManuallyAdjusted()) {
            return commerceOrder;
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            this._commerceOrderItemLocalService.updateCommerceOrderItemPrice(commerceOrderItem.getCommerceOrderItemId(), commerceContext);
        }
        commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceOrderPrice commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, false, commerceContext);
        CommerceMoney subtotalCommerceMoney = commerceOrderPrice.getSubtotal();
        CommerceMoney shippingValueCommerceMoney = commerceOrderPrice.getShippingValue();
        CommerceMoney taxValueCommerceMoney = commerceOrderPrice.getTaxValue();
        CommerceMoney totalCommerceMoney = commerceOrderPrice.getTotal();
        CommerceMoney subtotalWithTaxAmountCommerceMoney = commerceOrderPrice.getSubtotalWithTaxAmount();
        CommerceMoney shippingValueWithTaxAmountCommerceMoney = commerceOrderPrice.getShippingValueWithTaxAmount();
        CommerceMoney totalWithTaxAmountCommerceMoney = commerceOrderPrice.getTotalWithTaxAmount();
        commerceOrder.setShippingAmount(shippingValueCommerceMoney.getPrice());
        commerceOrder.setSubtotal(subtotalCommerceMoney.getPrice());
        commerceOrder.setTaxAmount(taxValueCommerceMoney.getPrice());
        commerceOrder.setTotal(totalCommerceMoney.getPrice());
        if (subtotalWithTaxAmountCommerceMoney != null) {
            commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmountCommerceMoney.getPrice());
        }
        if (shippingValueWithTaxAmountCommerceMoney != null) {
            commerceOrder.setShippingWithTaxAmount(shippingValueWithTaxAmountCommerceMoney.getPrice());
        }
        if (totalWithTaxAmountCommerceMoney != null) {
            commerceOrder.setTotalWithTaxAmount(totalWithTaxAmountCommerceMoney.getPrice());
        }
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValue(), false);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValue(), false);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValue(), false);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValueWithTaxAmount(), true);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValueWithTaxAmount(), true);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValueWithTaxAmount(), true);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder reorderCommerceOrder(long userId, long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceAddress billingAddress;
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(userId);
        long billingAddressId = 0L;
        long shippingAddressId = 0L;
        CommerceAddress shippingAddress = billingAddress = this.getNewCommerceAddress(commerceOrder, commerceOrder.getBillingAddress(), serviceContext);
        if (commerceOrder.getBillingAddressId() != commerceOrder.getShippingAddressId()) {
            shippingAddress = this.getNewCommerceAddress(commerceOrder, commerceOrder.getShippingAddress(), serviceContext);
        }
        if (billingAddress != null) {
            billingAddressId = billingAddress.getCommerceAddressId();
        }
        if (shippingAddress != null) {
            shippingAddressId = shippingAddress.getCommerceAddressId();
        }
        CommerceOrder newCommerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, commerceOrder.getGroupId(), billingAddressId, commerceOrder.getCommerceAccountId(), commerceOrder.getCommerceCurrencyId(), commerceOrder.getCommerceOrderTypeId(), commerceOrder.getCommerceShippingMethodId(), shippingAddressId, commerceOrder.getCommercePaymentMethodKey(), 0, 0, 0, 0, 0, 2, 1, "", commerceOrder.getShippingAmount(), commerceOrder.getShippingOptionName(), commerceOrder.getShippingWithTaxAmount(), commerceOrder.getSubtotal(), commerceOrder.getSubtotalWithTaxAmount(), commerceOrder.getTaxAmount(), commerceOrder.getTotal(), commerceOrder.getTotalWithTaxAmount(), serviceContext);
        List commerceOrderItems = this._commerceOrderItemLocalService.getCommerceOrderItems(commerceOrder.getCommerceOrderId(), -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.getParentCommerceOrderItemId() != 0L) continue;
            this._commerceOrderItemLocalService.addCommerceOrderItem(newCommerceOrder.getCommerceOrderId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), commerceOrderItem.getQuantity(), 0, commerceContext, serviceContext);
        }
        return newCommerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder resetCommerceOrderShipping(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(0L);
        commerceOrder.setShippingAmount(BigDecimal.ZERO);
        commerceOrder.setShippingOptionName(null);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public void resetCommerceOrderShippingByAddressId(long addressId) throws PortalException {
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(addressId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            if (!commerceOrder.isDraft() && !commerceOrder.isOpen()) continue;
            this.commerceOrderLocalService.resetCommerceOrderShipping(commerceOrder.getCommerceOrderId());
        }
    }

    public CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean resetDeliveryCommerceTerm, boolean resetPaymentCommerceTermEntry) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (resetDeliveryCommerceTerm) {
            commerceOrder.setDeliveryCommerceTermEntryId(0L);
            commerceOrder.setDeliveryCommerceTermEntryDescription(null);
            commerceOrder.setDeliveryCommerceTermEntryName(null);
        }
        if (resetPaymentCommerceTermEntry) {
            commerceOrder.setPaymentCommerceTermEntryId(0L);
            commerceOrder.setPaymentCommerceTermEntryDescription(null);
            commerceOrder.setPaymentCommerceTermEntryName(null);
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public BaseModelSearchResult<CommerceOrder> searchCommerceOrders(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceOrder.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceOrder> commerceOrders = this.getCommerceOrders(hits);
            if (commerceOrders == null) continue;
            return new BaseModelSearchResult(commerceOrders, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public long searchCommerceOrdersCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceOrder.class.getName());
        return indexer.searchCount(searchContext);
    }

    public CommerceOrder updateAccount(long commerceOrderId, long userId, long commerceAccountId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this._userLocalService.getUser(userId);
        commerceOrder.setUserId(user.getUserId());
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setCommerceAccountId(commerceAccountId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setBillingAddressId(billingAddressId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this.updateAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, CommerceOrderModel::getBillingAddressId, CommerceOrderModel::setBillingAddressId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalWithTaxAmount, CommerceContext commerceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setAdvanceStatus(advanceStatus);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setShippingOptionName(shippingOptionName);
        if (totalDiscountAmount == null) {
            totalDiscountAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        this._setCommerceOrderPrices(commerceOrder, shippingAmount, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal subtotal, BigDecimal total, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, commerceOrder.getShippingWithTaxAmount(), subtotal, commerceOrder.getSubtotalWithTaxAmount(), commerceOrder.getTaxAmount(), total, commerceOrder.getTotalDiscountAmount(), commerceOrder.getTotalWithTaxAmount(), commerceContext);
    }

    public void updateCommerceOrderAddresses(long addressId) throws PortalException {
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByBillingAddress(addressId);
        this._updateCommerceOrderAddresses(commerceOrders, addressId);
        commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(addressId);
        this._updateCommerceOrderAddresses(commerceOrders, addressId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount(), commerceOrder.getShippingDiscountWithTaxAmount(), commerceOrder.getShippingWithTaxAmount(), subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount(), commerceOrder.getSubtotalDiscountWithTaxAmount(), commerceOrder.getSubtotalWithTaxAmount(), taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, commerceOrder.getTotalDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel4WithTaxAmount(), commerceOrder.getTotalDiscountWithTaxAmount(), commerceOrder.getTotalWithTaxAmount());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setLastPriceUpdateDate(new Date());
        commerceOrder.setManuallyAdjusted(true);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingDiscountAmount(shippingDiscountAmount);
        commerceOrder.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        commerceOrder.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        commerceOrder.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        commerceOrder.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
        commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(shippingDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(shippingDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(shippingDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(shippingDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setShippingDiscountWithTaxAmount(shippingDiscountWithTaxAmount);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalDiscountAmount(subtotalDiscountAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        commerceOrder.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        commerceOrder.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        commerceOrder.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
        commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(subtotalDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(subtotalDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(subtotalDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(subtotalDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setSubtotalDiscountWithTaxAmount(subtotalDiscountWithTaxAmount);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        commerceOrder.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        commerceOrder.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        commerceOrder.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        commerceOrder.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
        commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(totalDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(totalDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(totalDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(totalDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setTotalDiscountWithTaxAmount(totalDiscountWithTaxAmount);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, BigDecimal shippingAmount, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingOptionName(commerceShippingOptionName);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethod.getCommerceShippingMethodId());
        commerceOrder.setShippingOptionName(commerceShippingOptionName);
        CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(commerceShippingMethod.getEngineKey());
        List commerceShippingOptions = commerceShippingEngine.getCommerceShippingOptions(commerceContext, commerceOrder, locale);
        for (CommerceShippingOption commerceShippingOption : commerceShippingOptions) {
            if (!Validator.isNotNull((String)commerceShippingOptionName) || !commerceShippingOptionName.equals(commerceShippingOption.getKey())) continue;
            commerceOrder.setShippingAmount(commerceShippingOption.getAmount());
            break;
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        Date requestedDeliveryDate = PortalUtil.getDate((int)requestedDeliveryDateMonth, (int)requestedDeliveryDateDay, (int)requestedDeliveryDateYear, (int)requestedDeliveryDateHour, (int)requestedDeliveryDateMinute, (TimeZone)user.getTimeZone(), CommerceOrderRequestedDeliveryDateException.class);
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setPrintedNote(printedNote);
        commerceOrder.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setOrderDate(PortalUtil.getDate((int)orderDateMonth, (int)orderDateDay, (int)orderDateYear, (int)orderDateHour, (int)orderDateMinute, (TimeZone)user.getTimeZone(), CommerceOrderDateException.class));
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePaymentStatus(long userId, long commerceOrderId, int paymentStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.updatePaymentStatusAndTransactionId(userId, commerceOrderId, paymentStatus, commerceOrder.getTransactionId());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePaymentStatusAndTransactionId(long userId, long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        int previousPaymentStatus = commerceOrder.getPaymentStatus();
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setTransactionId(transactionId);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        this.sendPaymentStatusMessage(commerceOrder, previousPaymentStatus);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setPrintedNote(printedNote);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        this.validatePurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this.updateAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, CommerceOrderModel::getShippingAddressId, CommerceOrderModel::setShippingAddressId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateStatus(long userId, long commerceOrderId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (userId == 0L) {
            userId = serviceContext.getUserId();
        }
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setStatus(status);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceTermEntry deliveryCommerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(deliveryCommerceTermEntryId);
        CommerceTermEntry paymentCommerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(paymentCommerceTermEntryId);
        if (deliveryCommerceTermEntry == null && paymentCommerceTermEntry == null) {
            return commerceOrder;
        }
        if (deliveryCommerceTermEntry != null) {
            commerceOrder.setDeliveryCommerceTermEntryId(deliveryCommerceTermEntry.getCommerceTermEntryId());
            commerceOrder.setDeliveryCommerceTermEntryDescription(deliveryCommerceTermEntry.getDescription(languageId, true));
            commerceOrder.setDeliveryCommerceTermEntryName(deliveryCommerceTermEntry.getLabel(languageId, true));
        }
        if (paymentCommerceTermEntry != null) {
            commerceOrder.setPaymentCommerceTermEntryId(paymentCommerceTermEntry.getCommerceTermEntryId());
            commerceOrder.setPaymentCommerceTermEntryDescription(paymentCommerceTermEntry.getDescription(languageId, true));
            commerceOrder.setPaymentCommerceTermEntryName(paymentCommerceTermEntry.getLabel(languageId, true));
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Deprecated
    public CommerceOrder upsertCommerceOrder(String externalReferenceCode, long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, String advanceStatus, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceOrder = this.commerceOrderPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (commerceOrder != null) {
            commerceOrder = this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrder.getCommerceOrderId(), billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, subtotal, total, commerceContext);
            commerceOrder = this.commerceOrderLocalService.updatePaymentStatus(userId, commerceOrder.getCommerceOrderId(), paymentStatus);
            commerceOrder.setOrderStatus(paymentStatus);
            return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        }
        commerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, 0L, commerceShippingMethodId, shippingAddressId, commercePaymentMethodKey, 0, 0, 0, 0, 0, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, BigDecimal.ZERO, subtotal, BigDecimal.ZERO, BigDecimal.ZERO, total, BigDecimal.ZERO, serviceContext);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    protected SearchContext addFacetOrderStatus(boolean negated, int[] orderStatuses, SearchContext searchContext) {
        NegatableMultiValueFacet negatableMultiValueFacet = new NegatableMultiValueFacet(searchContext);
        negatableMultiValueFacet.setFieldName("orderStatus");
        searchContext.addFacet((Facet)negatableMultiValueFacet);
        negatableMultiValueFacet.setNegated(negated);
        searchContext.setAttribute(negatableMultiValueFacet.getFieldId(), (Serializable)((Object)StringUtil.merge((int[])orderStatuses)));
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long commerceChannelGroupId, long[] commerceAccountIds, String keywords, boolean negated, int[] orderStatuses, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        if (orderStatuses != null) {
            searchContext.setAttribute("negateOrderStatuses", (Serializable)Boolean.valueOf(negated));
            searchContext.setAttribute("orderStatuses", (Serializable)orderStatuses);
        }
        if (commerceAccountIds != null) {
            searchContext.setAttribute("commerceAccountIds", (Serializable)commerceAccountIds);
        }
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{commerceChannelGroupId});
        searchContext.setKeywords(keywords);
        searchContext.setSorts(new Sort[]{SortFactoryUtil.getSort(CommerceOrder.class, (int)6, (String)"createDate", (String)"DESC")});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected String getCommerceOrderPaymentContent(CommercePaymentEngineException commercePaymentEngineException) {
        return StackTraceUtil.getStackTrace((Throwable)commercePaymentEngineException);
    }

    protected List<CommerceOrder> getCommerceOrders(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrder> commerceOrders = new ArrayList<CommerceOrder>(documents.size());
        for (Document document : documents) {
            long commerceOrderId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrder commerceOrder = this.fetchCommerceOrder(commerceOrderId);
            if (commerceOrder == null) {
                commerceOrders = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceOrder.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrders == null) continue;
            commerceOrders.add(commerceOrder);
        }
        return commerceOrders;
    }

    protected CommerceAddress getNewCommerceAddress(CommerceOrder commerceOrder, CommerceAddress commerceAddress, ServiceContext serviceContext) throws PortalException {
        if (commerceAddress == null) {
            return commerceAddress;
        }
        List commerceAddresses = this._commerceAddressLocalService.getCommerceAddressesByCompanyId(serviceContext.getCompanyId(), AccountEntry.class.getName(), commerceOrder.getCommerceAccountId());
        for (CommerceAddress newCommerceAddress : commerceAddresses) {
            if (!commerceAddress.isSameAddress(newCommerceAddress)) continue;
            return newCommerceAddress;
        }
        return this._commerceAddressLocalService.copyCommerceAddress(commerceAddress.getCommerceAddressId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId(), serviceContext);
    }

    protected boolean hasWorkflowDefinition(long groupId, long typePK) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return false;
        }
        return this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), CommerceOrder.class.getName(), 0L, typePK);
    }

    protected void sendPaymentStatusMessage(CommerceOrder commerceOrder, int previousPaymentStatus) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.setPayload((Object)JSONUtil.put((String)"commerceOrder", () -> {
                DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(CommerceOrder.class.getName());
                Object object = dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceOrder.getCommerceOrderId(), LocaleUtil.getSiteDefault(), null, null));
                return JSONFactoryUtil.createJSONObject((String)object.toString());
            }).put("commerceOrderId", commerceOrder.getCommerceOrderId()).put("paymentStatus", commerceOrder.getPaymentStatus()).put("previousPaymentStatus", previousPaymentStatus));
            MessageBusUtil.sendMessage((String)"liferay/commerce_payment_status", (Message)message);
            return null;
        });
    }

    protected CommerceOrder updateAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, Function<CommerceOrder, Long> commerceAddressIdGetter, BiConsumer<CommerceOrder, Long> commerceAddressIdSetter, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceAddress commerceAddress = null;
        long commerceAddressId = commerceAddressIdGetter.apply(commerceOrder);
        commerceAddress = commerceAddressId > 0L ? this._commerceAddressLocalService.updateCommerceAddress(commerceAddressId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, false, false, serviceContext) : this._commerceAddressLocalService.addCommerceAddress(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, false, false, serviceContext);
        commerceAddressIdSetter.accept(commerceOrder, commerceAddress.getCommerceAddressId());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    protected void validateAccountOrdersLimit(long commerceChannelGroupId, long commerceAccountId) throws PortalException {
        Group group = this._groupLocalService.getGroup(commerceChannelGroupId);
        int pendingCommerceOrdersCount = (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), commerceChannelGroupId, new long[]{commerceAccountId}, "", new int[]{2}, false);
        CommerceOrderFieldsConfiguration commerceOrderFieldsConfiguration = (CommerceOrderFieldsConfiguration)this._configurationProvider.getConfiguration(CommerceOrderFieldsConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannelGroupId, "com.liferay.commerce.order.fields"));
        if (commerceOrderFieldsConfiguration.accountCartMaxAllowed() > 0 && pendingCommerceOrdersCount >= commerceOrderFieldsConfiguration.accountCartMaxAllowed()) {
            throw new CommerceOrderAccountLimitException("The account carts limit was reached");
        }
    }

    protected void validateCheckout(CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isDraft() || !commerceOrder.isOpen() && !commerceOrder.isSubscription()) {
            throw new CommerceOrderStatusException();
        }
        if (commerceOrder.isB2B() && commerceOrder.getBillingAddressId() <= 0L) {
            throw new CommerceOrderBillingAddressException();
        }
        CommerceShippingMethod commerceShippingMethod = null;
        long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
        if (commerceShippingMethodId > 0L) {
            commerceShippingMethod = this._commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
            if (!commerceShippingMethod.isActive()) {
                commerceShippingMethod = null;
            } else if (commerceOrder.getShippingAddressId() <= 0L) {
                throw new CommerceOrderShippingAddressException();
            }
        }
        int count = this._commerceShippingMethodLocalService.getCommerceShippingMethodsCount(commerceOrder.getGroupId(), true);
        if (commerceShippingMethod == null && count > 0 && this._commerceShippingHelper.isShippable(commerceOrder)) {
            throw new CommerceOrderShippingMethodException();
        }
        BigDecimal subtotal = commerceOrder.getSubtotal();
        if (commerceOrder.isSubscriptionOrder() && Validator.isNull((String)commerceOrder.getCommercePaymentMethodKey()) && subtotal.compareTo(BigDecimal.ZERO) > 0) {
            throw new CommerceOrderPaymentMethodException();
        }
    }

    protected void validateGuestOrders() throws PortalException {
        int count = this.commerceOrderPersistence.countByUserId(0L);
        if (count >= this._commerceOrderConfiguration.guestCartMaxAllowed()) {
            throw new GuestCartMaxAllowedException();
        }
    }

    protected void validatePurchaseOrderNumber(String purchaseOrderNumber) throws PortalException {
        if (Validator.isNull((String)purchaseOrderNumber)) {
            throw new CommerceOrderPurchaseOrderNumberException();
        }
    }

    private void _setCommerceOrderPrices(CommerceOrder commerceOrder, BigDecimal shippingAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount) {
        if (shippingAmount == null) {
            shippingAmount = BigDecimal.ZERO;
        }
        if (shippingWithTaxAmount == null) {
            shippingWithTaxAmount = BigDecimal.ZERO;
        }
        if (subtotal == null) {
            subtotal = BigDecimal.ZERO;
        }
        if (subtotalWithTaxAmount == null) {
            subtotalWithTaxAmount = BigDecimal.ZERO;
        }
        if (taxAmount == null) {
            taxAmount = BigDecimal.ZERO;
        }
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (totalWithTaxAmount == null) {
            totalWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
    }

    private void _setCommerceOrderShippingDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean withTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (withTaxAmount) {
            commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrder.setShippingDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrder.setShippingDiscountAmount(discountAmount);
            commerceOrder.setShippingDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setShippingDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setShippingDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setShippingDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderSubtotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean withTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1 && percentages[0] != null) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2 && percentages[1] != null) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3 && percentages[2] != null) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4 && percentages[3] != null) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (withTaxAmount) {
            commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrder.setSubtotalDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrder.setSubtotalDiscountAmount(discountAmount);
            commerceOrder.setSubtotalDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setSubtotalDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setSubtotalDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setSubtotalDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderTotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean withTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (withTaxAmount) {
            commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrder.setTotalDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrder.setTotalDiscountAmount(discountAmount);
            commerceOrder.setTotalDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setTotalDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setTotalDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setTotalDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _updateCommerceOrderAddresses(List<CommerceOrder> commerceOrders, long addressId) throws PortalException {
        for (CommerceOrder commerceOrder : commerceOrders) {
            long billingAddressId = commerceOrder.getBillingAddressId();
            long shippingAddressId = commerceOrder.getShippingAddressId();
            long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
            String shippingOptionName = commerceOrder.getShippingOptionName();
            BigDecimal shippingPrice = commerceOrder.getShippingAmount();
            if (billingAddressId == addressId) {
                billingAddressId = 0L;
            }
            if (shippingAddressId == addressId) {
                shippingAddressId = 0L;
                commerceShippingMethodId = 0L;
                shippingOptionName = null;
                shippingPrice = BigDecimal.ZERO;
            }
            this.commerceOrderLocalService.updateCommerceOrder(null, commerceOrder.getCommerceOrderId(), billingAddressId, commerceShippingMethodId, shippingAddressId, commerceOrder.getAdvanceStatus(), commerceOrder.getCommercePaymentMethodKey(), commerceOrder.getPurchaseOrderNumber(), shippingPrice, shippingOptionName, commerceOrder.getSubtotal(), commerceOrder.getTotal(), null);
        }
    }
}

