/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_5_0;

import com.liferay.account.constants.AccountListTypeConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class CommerceAddressTypeUpgradeProcess
extends UpgradeProcess {
    private final ListTypeLocalService _listTypeLocalService;

    public CommerceAddressTypeUpgradeProcess(ListTypeLocalService listTypeLocalService) {
        this._listTypeLocalService = listTypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._setAddressListType(this._getListTypeId("billing"), 14000L);
        this._setAddressListType(this._getListTypeId("shipping"), 14002L);
        this._setAddressListType(this._getListTypeId("billing-and-shipping"), 14001L);
    }

    private long _getListTypeId(String name) {
        ListType listType = this._listTypeLocalService.getListType(name, AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        if (listType == null) {
            listType = this._listTypeLocalService.addListType(name, AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        }
        return listType.getListTypeId();
    }

    private void _setAddressListType(long newListTypeId, long oldListTypeId) throws Exception {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"update Address set listTypeId = ", newListTypeId, " where listTypeId = ", oldListTypeId}));
    }
}

