/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"indexer.class.name=com.liferay.commerce.model.CommerceOrder"}, service={ModelDocumentContributor.class})
public class CommerceOrderModelDocumentContributor
implements ModelDocumentContributor<CommerceOrder> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelDocumentContributor.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;

    public void contribute(Document document, CommerceOrder commerceOrder) {
        block3: {
            try {
                CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
                document.addNumberSortable("entryClassPK", Long.valueOf(commerceOrder.getCommerceOrderId()));
                document.addKeyword("status", commerceOrder.getStatus());
                AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(commerceOrder.getCommerceAccountId());
                if (accountEntry != null) {
                    document.addKeyword("accountName", accountEntry.getName());
                }
                document.addKeyword("advanceStatus", commerceOrder.getAdvanceStatus());
                document.addKeyword("commerceAccountId", commerceOrder.getCommerceAccountId());
                document.addKeyword("commerceChannelId", commerceChannel.getCommerceChannelId());
                document.addNumber("itemsQuantity", this._getItemsQuantity(commerceOrder));
                document.addKeyword("orderStatus", commerceOrder.getOrderStatus());
                document.addKeyword("purchaseOrderNumber", commerceOrder.getPurchaseOrderNumber());
                document.addKeyword("externalReferenceCode", commerceOrder.getExternalReferenceCode());
                document.addNumber("total", commerceOrder.getTotal());
                document.addDate("orderDate", commerceOrder.getOrderDate());
                document.addDateSortable("orderDate", commerceOrder.getOrderDate());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to index commerce order " + commerceOrder.getCommerceOrderId()), (Throwable)exception);
            }
        }
    }

    private int _getItemsQuantity(CommerceOrder commerceOrder) {
        int count = 0;
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            count += commerceOrderItem.getQuantity();
        }
        return count;
    }
}

