/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.HashMap;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=false, immediate=true, property={"commerce.order.status.key=1", "commerce.order.status.priority:Integer=30"}, service={CommerceOrderStatus.class})
public class PendingCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 1;
    public static final int PRIORITY = 30;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private Language _language;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        commerceOrder.setOrderStatus(1);
        commerceOrder = this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        if (this.isWorkflowEnabled(commerceOrder)) {
            commerceOrder.setStatus(1);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(commerceOrder.getGroupId());
            serviceContext.setUserId(userId);
            serviceContext.setWorkflowAction(1);
            commerceOrder = (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getScopeGroupId(), (long)userId, (String)CommerceOrder.class.getName(), (long)commerceOrder.getCommerceOrderId(), (Object)commerceOrder, (ServiceContext)serviceContext, new HashMap());
        }
        return this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 1;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)1));
    }

    public int getPriority() {
        return 30;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return !commerceOrder.isOpen() && commerceOrder.isApproved();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commerceOrder.getCommercePaymentMethodKey());
        if (commercePaymentMethod == null) {
            return true;
        }
        if (commerceOrder.getPaymentStatus() == 0 || commercePaymentMethod.getPaymentType() == 2) {
            return this._commerceOrderValidatorRegistry.isValid(LocaleUtil.getSiteDefault(), commerceOrder);
        }
        return false;
    }

    public boolean isWorkflowEnabled(CommerceOrder commerceOrder) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 1L, true);
        return workflowDefinitionLink != null;
    }
}

