/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.DuplicateCommerceShippingOptionAccountEntryRelException;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.service.base.CommerceShippingOptionAccountEntryRelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.spring.extender.service.ServiceReference;

public class CommerceShippingOptionAccountEntryRelLocalServiceImpl
extends CommerceShippingOptionAccountEntryRelLocalServiceBaseImpl {
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public CommerceShippingOptionAccountEntryRel addCommerceShippingOptionAccountEntryRel(long userId, long accountEntryId, long commerceChannelId, String commerceShippingMethodKey, String commerceShippingOptionKey) throws PortalException {
        this._validate(accountEntryId, commerceChannelId);
        long commerceShippingOptionAccountEntryRelId = this.counterLocalService.increment();
        CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel = this.commerceShippingOptionAccountEntryRelPersistence.create(commerceShippingOptionAccountEntryRelId);
        User user = this._userLocalService.getUser(userId);
        commerceShippingOptionAccountEntryRel.setCompanyId(user.getCompanyId());
        commerceShippingOptionAccountEntryRel.setUserId(user.getUserId());
        commerceShippingOptionAccountEntryRel.setUserName(user.getFullName());
        commerceShippingOptionAccountEntryRel.setAccountEntryId(accountEntryId);
        commerceShippingOptionAccountEntryRel.setCommerceChannelId(commerceChannelId);
        commerceShippingOptionAccountEntryRel.setCommerceShippingMethodKey(commerceShippingMethodKey);
        commerceShippingOptionAccountEntryRel.setCommerceShippingOptionKey(commerceShippingOptionKey);
        return (CommerceShippingOptionAccountEntryRel)this.commerceShippingOptionAccountEntryRelPersistence.update((BaseModel)commerceShippingOptionAccountEntryRel);
    }

    public void deleteCommerceShippingOptionAccountEntryRelsByAccountEntryId(long accountEntryId) {
        this.commerceShippingOptionAccountEntryRelPersistence.removeByAccountEntryId(accountEntryId);
    }

    public void deleteCommerceShippingOptionAccountEntryRelsByCommerceChannelId(long commerceChannelId) {
        this.commerceShippingOptionAccountEntryRelPersistence.removeByCommerceChannelId(commerceChannelId);
    }

    public void deleteCommerceShippingOptionAccountEntryRelsByCSFixedOptionKey(String commerceShippingFixedOptionKey) {
        this.commerceShippingOptionAccountEntryRelPersistence.removeByCommerceShippingOptionKey(commerceShippingFixedOptionKey);
    }

    public CommerceShippingOptionAccountEntryRel fetchCommerceShippingOptionAccountEntryRel(long accountEntryId, long commerceChannelId) {
        return this.commerceShippingOptionAccountEntryRelPersistence.fetchByA_C(accountEntryId, commerceChannelId);
    }

    public CommerceShippingOptionAccountEntryRel updateCommerceShippingOptionAccountEntryRel(long commerceShippingOptionAccountEntryRelId, String commerceShippingMethodKey, String commerceShippingOptionKey) throws PortalException {
        CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel = this.commerceShippingOptionAccountEntryRelPersistence.findByPrimaryKey(commerceShippingOptionAccountEntryRelId);
        commerceShippingOptionAccountEntryRel.setCommerceShippingMethodKey(commerceShippingMethodKey);
        commerceShippingOptionAccountEntryRel.setCommerceShippingOptionKey(commerceShippingOptionKey);
        return (CommerceShippingOptionAccountEntryRel)this.commerceShippingOptionAccountEntryRelPersistence.update((BaseModel)commerceShippingOptionAccountEntryRel);
    }

    private void _validate(long accountEntryId, long commerceChannelId) throws PortalException {
        CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel = this.commerceShippingOptionAccountEntryRelPersistence.fetchByA_C(accountEntryId, commerceChannelId);
        if (commerceShippingOptionAccountEntryRel != null) {
            throw new DuplicateCommerceShippingOptionAccountEntryRelException();
        }
    }
}

