/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.address;

import com.liferay.commerce.address.CommerceAddressFormatter;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, immediate=true, service={CommerceAddressFormatter.class})
public class CommerceAddressFormatterImpl
implements CommerceAddressFormatter {
    public String getBasicAddress(CommerceAddress commerceAddress) throws PortalException {
        StringBundler sb = new StringBundler(14);
        sb.append(commerceAddress.getStreet1());
        sb.append("\n");
        if (Validator.isNotNull((String)commerceAddress.getStreet2())) {
            sb.append(commerceAddress.getStreet2());
            sb.append("\n");
        }
        if (Validator.isNotNull((String)commerceAddress.getStreet3())) {
            sb.append(commerceAddress.getStreet3());
            sb.append("\n");
        }
        sb.append(commerceAddress.getCity());
        sb.append(" ");
        Region region = commerceAddress.getRegion();
        if (region != null) {
            sb.append(region.getRegionCode());
            sb.append(" ");
        }
        sb.append(commerceAddress.getZip());
        sb.append("\n");
        Country country = commerceAddress.getCountry();
        if (country != null) {
            sb.append(country.getName());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getDescriptiveAddress(CommerceAddress commerceAddress, boolean showDescription) throws PortalException {
        StringBundler sb = new StringBundler(8);
        sb.append(commerceAddress.getName());
        sb.append("\n");
        if (Validator.isNotNull((String)commerceAddress.getPhoneNumber())) {
            sb.append(commerceAddress.getPhoneNumber());
            sb.append("\n");
        }
        sb.append(this.getBasicAddress(commerceAddress));
        String description = commerceAddress.getDescription();
        if (description != null && showDescription) {
            sb.append("\n");
            sb.append("\n");
            sb.append(description);
        }
        return sb.toString();
    }

    public String getOneLineAddress(CommerceAddress commerceAddress) throws PortalException {
        StringBundler sb = new StringBundler(7);
        sb.append(commerceAddress.getStreet1());
        sb.append(", ");
        sb.append(commerceAddress.getCity());
        sb.append(" ");
        Region region = commerceAddress.getRegion();
        if (region != null) {
            sb.append(region.getRegionCode());
            sb.append(" ");
        }
        sb.append(commerceAddress.getZip());
        return sb.toString();
    }
}

