/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.service.base;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.commerce.service.CommerceOrderTypeServiceUtil;
import com.liferay.commerce.service.persistence.CommerceOrderTypePersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;

import java.lang.reflect.Field;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the commerce order type remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.commerce.service.impl.CommerceOrderTypeServiceImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see com.liferay.commerce.service.impl.CommerceOrderTypeServiceImpl
 * @generated
 */
public abstract class CommerceOrderTypeServiceBaseImpl
	extends BaseServiceImpl
	implements CommerceOrderTypeService, IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>CommerceOrderTypeService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>CommerceOrderTypeServiceUtil</code>.
	 */

	/**
	 * Returns the commerce order type local service.
	 *
	 * @return the commerce order type local service
	 */
	public com.liferay.commerce.service.CommerceOrderTypeLocalService
		getCommerceOrderTypeLocalService() {

		return commerceOrderTypeLocalService;
	}

	/**
	 * Sets the commerce order type local service.
	 *
	 * @param commerceOrderTypeLocalService the commerce order type local service
	 */
	public void setCommerceOrderTypeLocalService(
		com.liferay.commerce.service.CommerceOrderTypeLocalService
			commerceOrderTypeLocalService) {

		this.commerceOrderTypeLocalService = commerceOrderTypeLocalService;
	}

	/**
	 * Returns the commerce order type remote service.
	 *
	 * @return the commerce order type remote service
	 */
	public CommerceOrderTypeService getCommerceOrderTypeService() {
		return commerceOrderTypeService;
	}

	/**
	 * Sets the commerce order type remote service.
	 *
	 * @param commerceOrderTypeService the commerce order type remote service
	 */
	public void setCommerceOrderTypeService(
		CommerceOrderTypeService commerceOrderTypeService) {

		this.commerceOrderTypeService = commerceOrderTypeService;
	}

	/**
	 * Returns the commerce order type persistence.
	 *
	 * @return the commerce order type persistence
	 */
	public CommerceOrderTypePersistence getCommerceOrderTypePersistence() {
		return commerceOrderTypePersistence;
	}

	/**
	 * Sets the commerce order type persistence.
	 *
	 * @param commerceOrderTypePersistence the commerce order type persistence
	 */
	public void setCommerceOrderTypePersistence(
		CommerceOrderTypePersistence commerceOrderTypePersistence) {

		this.commerceOrderTypePersistence = commerceOrderTypePersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
		_setServiceUtilService(commerceOrderTypeService);
	}

	public void destroy() {
		_setServiceUtilService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return CommerceOrderTypeService.class.getName();
	}

	protected Class<?> getModelClass() {
		return CommerceOrderType.class;
	}

	protected String getModelClassName() {
		return CommerceOrderType.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource =
				commerceOrderTypePersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	private void _setServiceUtilService(
		CommerceOrderTypeService commerceOrderTypeService) {

		try {
			Field field = CommerceOrderTypeServiceUtil.class.getDeclaredField(
				"_service");

			field.setAccessible(true);

			field.set(null, commerceOrderTypeService);
		}
		catch (ReflectiveOperationException reflectiveOperationException) {
			throw new RuntimeException(reflectiveOperationException);
		}
	}

	@BeanReference(
		type = com.liferay.commerce.service.CommerceOrderTypeLocalService.class
	)
	protected com.liferay.commerce.service.CommerceOrderTypeLocalService
		commerceOrderTypeLocalService;

	@BeanReference(type = CommerceOrderTypeService.class)
	protected CommerceOrderTypeService commerceOrderTypeService;

	@BeanReference(type = CommerceOrderTypePersistence.class)
	protected CommerceOrderTypePersistence commerceOrderTypePersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

}