/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.base;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public abstract class BaseCommerceServiceUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceServiceUpgradeProcess.class);

    protected void addColumn(String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        this.alterTableAddColumn(tableName, columnName, columnType);
    }

    protected void changeColumnType(String tableName, String columnName, String newColumnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Changing column %s to type %s for table %s", columnName, newColumnType, tableName));
        }
        this.alterColumnType(tableName, columnName, newColumnType);
    }

    protected abstract void doUpgrade() throws Exception;

    protected void dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        this.alterTableDropColumn(tableName, columnName);
    }

    protected void renameColumn(String tableName, String oldColumnName, String newColumnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Renaming column %s to table %s", oldColumnName, tableName));
        }
        this.alterColumnName(tableName, oldColumnName, newColumnName);
    }
}

