/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.base.CommerceOrderServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public class CommerceOrderServiceImpl
extends CommerceOrderServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceOrderServiceImpl.class, (String)"_commerceOrderModelResourcePermission", CommerceOrder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceOrderServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce.order");
    @ServiceReference(type=CommerceAccountHelper.class)
    private CommerceAccountHelper _commerceAccountHelper;
    @ServiceReference(type=CommerceAccountLocalService.class)
    private CommerceAccountLocalService _commerceAccountLocalService;
    @ServiceReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;

    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_COMMERCE_ORDER");
        return this.commerceOrderLocalService.addCommerceOrder(this.getUserId(), groupId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId);
    }

    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        if (commerceOrder == null) {
            _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_COMMERCE_ORDER");
        } else {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE");
        }
        return this.commerceOrderLocalService.addOrUpdateCommerceOrder(externalReferenceCode, this.getUserId(), groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderService.addOrUpdateCommerceOrder(externalReferenceCode, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, 0, 0, 0, 0, 0, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "DELETE");
        this.commerceOrderLocalService.deleteCommerceOrder(commerceOrderId);
    }

    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.executeWorkflowTransition(this.getUserId(), commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public CommerceOrder fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceOrderId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceAccountId, groupId, userId, orderStatus);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public int getCommerceOrdersCount(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId, commerceAccountId);
    }

    public List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_OPEN_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false, start, end);
    }

    public long getPendingCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, "", new int[]{2}, false);
    }

    public int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_OPEN_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false);
    }

    public List<CommerceOrder> getPlacedCommerceOrders(long companyId, long groupId, int start, int end) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, "", new int[]{2}, true, start, end);
    }

    public List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, true, start, end);
    }

    public long getPlacedCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, "", new int[]{2}, true);
    }

    public int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, true);
    }

    public List<CommerceOrder> getUserCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, new int[]{-1}, true, start, end);
    }

    public long getUserCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, new int[]{-1}, true);
    }

    public List<CommerceOrder> getUserPendingCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, false, start, end);
    }

    public long getUserPendingCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, false);
    }

    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, true, start, end);
    }

    public long getUserPlacedCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, true);
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), guestCommerceOrderId, "VIEW");
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), userCommerceOrderId, "UPDATE");
        this.commerceOrderLocalService.mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
    }

    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderLocalService.reorderCommerceOrder(this.getUserId(), commerceOrderId, commerceContext);
    }

    public CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean deliveryCommerceTermEntry, boolean paymentCommerceTermEntry) throws PortalException {
        if (deliveryCommerceTermEntry) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS");
        }
        if (paymentCommerceTermEntry) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS");
        }
        return this.commerceOrderLocalService.resetTermsAndConditions(commerceOrderId, deliveryCommerceTermEntry, paymentCommerceTermEntry);
    }

    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateBillingAddress(commerceOrderId, billingAddressId);
    }

    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrder.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(commerceOrder);
    }

    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalWithTaxAmount, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, totalDiscountAmount, commerceContext);
    }

    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal subtotal, BigDecimal total, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, subtotal, total, commerceContext);
    }

    public CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrderExternalReferenceCode(externalReferenceCode, commerceOrderId);
    }

    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderLocalService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderLocalService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, shippingDiscountPercentageLevel1WithTaxAmount, shippingDiscountPercentageLevel2WithTaxAmount, shippingDiscountPercentageLevel3WithTaxAmount, shippingDiscountPercentageLevel4WithTaxAmount, shippingDiscountWithTaxAmount, shippingWithTaxAmount, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, subtotalDiscountPercentageLevel1WithTaxAmount, subtotalDiscountPercentageLevel2WithTaxAmount, subtotalDiscountPercentageLevel3WithTaxAmount, subtotalDiscountPercentageLevel4WithTaxAmount, subtotalDiscountWithTaxAmount, subtotalWithTaxAmount, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, totalDiscountPercentageLevel1WithTaxAmount, totalDiscountPercentageLevel2WithTaxAmount, totalDiscountPercentageLevel3WithTaxAmount, totalDiscountPercentageLevel4WithTaxAmount, totalDiscountWithTaxAmount, totalWithTaxAmount);
    }

    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceShippingMethod(commerceOrderId, commerceShippingMethodId, commerceShippingOptionName, commerceContext, locale);
    }

    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    @Deprecated
    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePrintedNote(commerceOrderId, printedNote);
    }

    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateShippingAddress(commerceOrderId, shippingAddressId);
    }

    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        if (deliveryCommerceTermEntryId > 0L) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS");
        }
        if (paymentCommerceTermEntryId > 0L) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS");
        }
        return this.commerceOrderLocalService.updateTermsAndConditions(commerceOrderId, deliveryCommerceTermEntryId, paymentCommerceTermEntryId, languageId);
    }

    private void _checkAccountOrder(long groupId, long commerceAccountId, String action) throws PortalException {
        CommerceAccount commerceAccount = this._commerceAccountLocalService.fetchCommerceAccount(commerceAccountId);
        if (commerceAccount == null) {
            _portletResourcePermission.check(this.getPermissionChecker(), groupId, action);
        } else if (commerceAccount.isBusinessAccount()) {
            _portletResourcePermission.check(this.getPermissionChecker(), commerceAccount.getCommerceAccountGroup(), action);
        }
    }

    private long[] _getCommerceAccountIds(long groupId) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceOrderModelResourcePermission.getPortletResourcePermission();
        if (!portletResourcePermission.contains(this.getPermissionChecker(), groupId, "MANAGE_ALL_ACCOUNTS")) {
            return this._commerceAccountHelper.getUserCommerceAccountIds(this.getUserId(), groupId);
        }
        return null;
    }
}

