/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=false, immediate=true, property={"commerce.order.status.key=8", "commerce.order.status.priority:Integer=-1"}, service={CommerceOrderStatus.class})
public class CancelledCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 8;
    public static final int PRIORITY = -1;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderStatusRegistry _commerceOrderStatusRegistry;
    @Reference
    private Language _language;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        commerceOrder.setOrderStatus(8);
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 8;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)8));
    }

    public int getPriority() {
        return -1;
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        CommerceOrderStatus currentCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
        return currentCommerceOrderStatus.getKey() != 8 && currentCommerceOrderStatus.getKey() != 0 && currentCommerceOrderStatus.getKey() != 2;
    }
}

