/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.events;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"key=login.events.post"}, service={LifecycleAction.class})
public class LoginPostAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(LoginPostAction.class);
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            Cookie[] cookies = httpServletRequest.getCookies();
            if (cookies == null) {
                return;
            }
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!name.startsWith(CommerceOrder.class.getName() + "#")) continue;
                HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
                HttpSession httpSession = originalHttpServletRequest.getSession();
                httpSession.setAttribute(name, (Object)cookie.getValue());
                this._updateGuestCommerceOrder(cookie.getValue(), Long.valueOf(StringUtil.extractLast((String)name, (String)"#")), httpServletRequest);
                break;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _updateGuestCommerceOrder(String commerceOrderUuid, long commerceChannelGroupId, HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = null;
        try {
            commerceOrder = this._commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannelGroupId);
        }
        catch (Exception exception) {
            return;
        }
        if (commerceOrder.getCommerceAccountId() != -1L) {
            return;
        }
        long userId = this._portal.getUserId(httpServletRequest);
        CommerceAccount commerceAccount = this._commerceAccountLocalService.getPersonalCommerceAccount(userId);
        CommerceOrder userCommerceOrder = this._commerceOrderLocalService.fetchCommerceOrder(commerceAccount.getCommerceAccountId(), commerceChannelGroupId, userId, 2);
        if (userCommerceOrder != null) {
            CommerceContext commerceContext = this._commerceContextFactory.create(this._portal.getCompanyId(httpServletRequest), commerceChannelGroupId, userId, userCommerceOrder.getCommerceOrderId(), commerceAccount.getCommerceAccountId());
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this._portal.getUser(httpServletRequest)));
            this._commerceOrderLocalService.mergeGuestCommerceOrder(commerceOrder.getCommerceOrderId(), userCommerceOrder.getCommerceOrderId(), commerceContext, serviceContext);
        } else {
            this._commerceOrderLocalService.updateAccount(commerceOrder.getCommerceOrderId(), userId, commerceAccount.getCommerceAccountId());
        }
    }
}

