/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v4_6_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;

/**
 * @author Luca Pellizzon
 */
public class SubscriptionUpgradeProcess
	extends BaseCommerceServiceUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		addColumn(
			"CommerceSubscriptionEntry", "deliverySubscriptionLength",
			"INTEGER");
		addColumn(
			"CommerceSubscriptionEntry", "deliverySubscriptionType",
			"VARCHAR(75)");
		addColumn(
			"CommerceSubscriptionEntry", "deliverySubTypeSettings", "TEXT");
		addColumn("CommerceSubscriptionEntry", "deliveryCurrentCycle", "LONG");
		addColumn(
			"CommerceSubscriptionEntry", "deliveryMaxSubscriptionCycles",
			"LONG");
		addColumn(
			"CommerceSubscriptionEntry", "deliverySubscriptionStatus",
			"INTEGER");
		addColumn(
			"CommerceSubscriptionEntry", "deliveryLastIterationDate", "DATE");
		addColumn(
			"CommerceSubscriptionEntry", "deliveryNextIterationDate", "DATE");
		addColumn("CommerceSubscriptionEntry", "deliveryStartDate", "DATE");
	}

}