/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v3_2_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceOrderItemUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		_addColumn("CommerceOrderItem", "deliveryGroup", "VARCHAR(75)");

		_addColumn("CommerceOrderItem", "shippingAddressId", "LONG");

		_addColumn("CommerceOrderItem", "printedNote", "VARCHAR(75)");

		_addColumn("CommerceOrderItem", "requestedDeliveryDate", "DATE");
	}

	private void _addColumn(
			String tableName, String columnName, String columnType)
		throws Exception {

		if (_log.isInfoEnabled()) {
			_log.info(
				String.format(
					"Adding column %s to table %s", columnName, tableName));
		}

		alterTableAddColumn(tableName, columnName, columnType);
	}

	private static final Log _log = LogFactoryUtil.getLog(
		CommerceOrderItemUpgradeProcess.class);

}