/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v4_5_1;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommerceShippingMethodUpgradeProcess
extends BaseCommerceServiceUpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;

    public CommerceShippingMethodUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select commerceShippingMethodId, groupId from CommerceShippingMethod");){
            PreparedStatement preparedStatement = null;
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long channelGroupId = this._getCommerceChannelGroupIdBySiteGroupId(groupId);
                if (channelGroupId == 0L) continue;
                long commerceShippingMethodId = resultSet.getLong("commerceShippingMethodId");
                preparedStatement = this.connection.prepareStatement("update CommerceShippingMethod set groupId = ? where commerceShippingMethodId = ?");
                preparedStatement.setLong(1, channelGroupId);
                preparedStatement.setLong(2, commerceShippingMethodId);
                preparedStatement.executeUpdate();
            }
        }
    }

    private long _getCommerceChannelGroupIdBySiteGroupId(long groupId) throws SQLException {
        long companyId = 0L;
        long commerceChannelId = 0L;
        String sql = "select * from CommerceChannel where siteGroupId = " + groupId;
        try (Statement s = this.connection.createStatement();){
            s.setMaxRows(1);
            try (ResultSet resultSet = s.executeQuery(sql);){
                if (resultSet.next()) {
                    companyId = resultSet.getLong("companyId");
                    commerceChannelId = resultSet.getLong("commerceChannelId");
                }
            }
        }
        long classNameId = this._classNameLocalService.getClassNameId(CommerceChannel.class.getName());
        Group group = this._groupLocalService.fetchGroup(companyId, classNameId, commerceChannelId);
        if (group != null) {
            return group.getGroupId();
        }
        return 0L;
    }
}

