/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_2_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountOrganizationRelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CommerceAccountUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceAccountUpgradeProcess.class);
    private final CommerceAccountLocalService _commerceAccountLocalService;
    private final CommerceAccountOrganizationRelLocalService _commerceAccountOrganizationRelLocalService;
    private final EmailAddressLocalService _emailAddressLocalService;
    private final OrganizationLocalService _organizationLocalService;

    public CommerceAccountUpgradeProcess(CommerceAccountLocalService commerceAccountLocalService, CommerceAccountOrganizationRelLocalService commerceAccountOrganizationRelLocalService, EmailAddressLocalService emailAddressLocalService, OrganizationLocalService organizationLocalService) {
        this._commerceAccountLocalService = commerceAccountLocalService;
        this._commerceAccountOrganizationRelLocalService = commerceAccountOrganizationRelLocalService;
        this._emailAddressLocalService = emailAddressLocalService;
        this._organizationLocalService = organizationLocalService;
    }

    protected void doUpgrade() throws Exception {
        ArrayList<Long> queuedOrganizationIds = new ArrayList<Long>();
        Statement s = this.connection.createStatement(1003, 1007);
        Object object = null;
        try (ResultSet resultSet2 = s.executeQuery("select organizationId from Organization_ where type_ = 'account'");){
            while (resultSet2.next()) {
                long organizationId = resultSet2.getLong("organizationId");
                queuedOrganizationIds.add(organizationId);
            }
        }
        catch (Throwable resultSet2) {
            object = resultSet2;
            throw resultSet2;
        }
        finally {
            if (s != null) {
                if (object != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable resultSet2) {
                        ((Throwable)object).addSuppressed(resultSet2);
                    }
                } else {
                    s.close();
                }
            }
        }
        while (!queuedOrganizationIds.isEmpty()) {
            ArrayList organizationIds = new ArrayList(queuedOrganizationIds);
            queuedOrganizationIds.clear();
            object = organizationIds.iterator();
            while (object.hasNext()) {
                long organizationId = (Long)object.next();
                Organization organization = this._organizationLocalService.getOrganization(organizationId);
                long parentCommerceAccountId = this._getParentCommerceAccountId(organization.getParentOrganizationId());
                if (parentCommerceAccountId < 0L) {
                    queuedOrganizationIds.add(organizationId);
                    continue;
                }
                this._addCommerceAccount(organization, parentCommerceAccountId);
            }
            if (queuedOrganizationIds.size() < organizationIds.size()) continue;
            _log.error((Object)"Organization data is missing, so accounts cannot be correctly created. Aborting data transformation.");
            String organizationIdsString = ListUtil.toString(organizationIds, (String)"", (String)", ");
            _log.error((Object)("The following organizations are orphaned: " + organizationIdsString));
            return;
        }
    }

    private void _addCommerceAccount(Organization organization, long parentCommerceAccountId) throws Exception {
        String email = this._getOrganizationEmailAddress(organization);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(organization.getCompanyId());
        serviceContext.setUserId(organization.getUserId());
        CommerceAccount commerceAccount = this._commerceAccountLocalService.addBusinessCommerceAccount(organization.getName(), parentCommerceAccountId, email, "", true, organization.getExternalReferenceCode(), new long[0], new String[0], serviceContext);
        this._commerceAccountOrganizationRelLocalService.addCommerceAccountOrganizationRel(commerceAccount.getCommerceAccountId(), organization.getOrganizationId(), serviceContext);
    }

    private String _getOrganizationEmailAddress(Organization organization) {
        List emailAddresses = this._emailAddressLocalService.getEmailAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        for (EmailAddress emailAddress : emailAddresses) {
            if (!emailAddress.isPrimary()) continue;
            return emailAddress.getAddress();
        }
        if (!emailAddresses.isEmpty()) {
            EmailAddress emailAddress = (EmailAddress)emailAddresses.get(0);
            return emailAddress.getAddress();
        }
        return "";
    }

    private long _getParentCommerceAccountId(long parentOrganizationId) throws Exception {
        if (parentOrganizationId == 0L) {
            return 0L;
        }
        Organization organization = this._organizationLocalService.getOrganization(parentOrganizationId);
        if (!Objects.equals(organization.getType(), "account")) {
            return 0L;
        }
        String sql = "select commerceAccountId from CommerceAccountOrganizationRel where organizationId = " + parentOrganizationId;
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(sql);){
            if (resultSet.next()) {
                long l = resultSet.getLong("commerceAccountId");
                return l;
            }
        }
        return -1L;
    }
}

