/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v4_9_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;

/**
 * @author Igor Beslic
 * @author Riccardo Alberti
 */
public class CommerceOrderItemUpgradeProcess
	extends BaseCommerceServiceUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		addColumn("CommerceOrderItem", "parentCommerceOrderItemId", "LONG");
		addColumn(
			"CommerceOrderItem", "unitPriceWithTaxAmount", "DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "promoPriceWithTaxAmount", "DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "discountWithTaxAmount", "DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "finalPriceWithTaxAmount", "DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "discountPctLevel1WithTaxAmount",
			"DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "discountPctLevel2WithTaxAmount",
			"DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "discountPctLevel3WithTaxAmount",
			"DECIMAL(30,16)");
		addColumn(
			"CommerceOrderItem", "discountPctLevel4WithTaxAmount",
			"DECIMAL(30,16)");
		addColumn("CommerceOrderItem", "commercePriceListId", "LONG");
	}

}