/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v4_6_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.internal.upgrade.v4_6_0.util.CommerceSubscriptionEntryTable;

/**
 * @author Luca Pellizzon
 */
public class SubscriptionUpgradeProcess
	extends BaseCommerceServiceUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliverySubscriptionLength")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliverySubscriptionLength",
				"INTEGER");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliverySubscriptionType")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliverySubscriptionType",
				"VARCHAR(75)");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliverySubTypeSettings")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliverySubTypeSettings", "TEXT");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliveryCurrentCycle")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliveryCurrentCycle", "LONG");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliveryMaxSubscriptionCycles")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliveryMaxSubscriptionCycles",
				"LONG");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliverySubscriptionStatus")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliverySubscriptionStatus",
				"INTEGER");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliveryLastIterationDate")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliveryLastIterationDate",
				"DATE");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliveryNextIterationDate")) {

			addColumn(
				"CommerceSubscriptionEntry", "deliveryNextIterationDate",
				"DATE");
		}

		if (!hasColumn(
				CommerceSubscriptionEntryTable.TABLE_NAME,
				"deliveryStartDate")) {

			addColumn("CommerceSubscriptionEntry", "deliveryStartDate", "DATE");
		}
	}

}