/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.base.CommerceAddressServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceAddressServiceImpl
extends CommerceAddressServiceBaseImpl {
    @ServiceReference(type=CommerceAccountService.class)
    private CommerceAccountService _commerceAccountService;

    @Deprecated
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, defaultBilling, defaultShipping, serviceContext);
    }

    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        return this.commerceAddressService.addCommerceAddress(null, className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, type, serviceContext);
    }

    public CommerceAddress addCommerceAddress(String externalReferenceCode, String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.addCommerceAddress(externalReferenceCode, className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, type, serviceContext);
    }

    public void deleteCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        this.commerceAddressLocalService.deleteCommerceAddress(commerceAddress);
    }

    public CommerceAddress fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceAddress != null) {
            this.checkPermission(commerceAddress);
        }
        return commerceAddress;
    }

    public CommerceAddress fetchCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.fetchCommerceAddress(commerceAddressId);
        if (commerceAddress != null) {
            this.checkPermission(commerceAddress);
        }
        return commerceAddress;
    }

    public List<CommerceAddress> getBillingCommerceAddresses(long companyId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getBillingCommerceAddresses(companyId, className, classPK);
    }

    public List<CommerceAddress> getBillingCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getBillingCommerceAddresses(companyId, className, classPK, keywords, start, end, sort);
    }

    public int getBillingCommerceAddressesCount(long companyId, String className, long classPK, String keywords) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getBillingCommerceAddressesCount(companyId, className, classPK, keywords);
    }

    public CommerceAddress getCommerceAddress(long commerceAddressId) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        return commerceAddress;
    }

    @Deprecated
    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddresses(groupId, className, classPK);
    }

    @Deprecated
    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddresses(groupId, className, classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddresses(String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddresses(className, classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddressesByCompanyId(long companyId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesByCompanyId(companyId, className, classPK);
    }

    public List<CommerceAddress> getCommerceAddressesByCompanyId(long companyId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesByCompanyId(companyId, className, classPK, start, end, orderByComparator);
    }

    @Deprecated
    public int getCommerceAddressesCount(long groupId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesCount(groupId, className, classPK);
    }

    public int getCommerceAddressesCount(String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesCount(className, classPK);
    }

    public int getCommerceAddressesCountByCompanyId(long companyId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getCommerceAddressesCountByCompanyId(companyId, className, classPK);
    }

    public List<CommerceAddress> getShippingCommerceAddresses(long companyId, String className, long classPK) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getShippingCommerceAddresses(companyId, className, classPK);
    }

    public List<CommerceAddress> getShippingCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getShippingCommerceAddresses(companyId, className, classPK, keywords, start, end, sort);
    }

    public int getShippingCommerceAddressesCount(long companyId, String className, long classPK, String keywords) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.getShippingCommerceAddressesCount(companyId, className, classPK, keywords);
    }

    @Deprecated
    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, long groupId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.searchCommerceAddresses(companyId, groupId, className, classPK, keywords, start, end, sort);
    }

    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        this.checkPermission(className, classPK);
        return this.commerceAddressLocalService.searchCommerceAddresses(companyId, className, classPK, keywords, start, end, sort);
    }

    @Deprecated
    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        return this.commerceAddressLocalService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, defaultBilling, defaultShipping, serviceContext);
    }

    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = this.commerceAddressLocalService.getCommerceAddress(commerceAddressId);
        this.checkPermission(commerceAddress);
        return this.commerceAddressLocalService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, type, serviceContext);
    }

    protected void checkPermission(CommerceAddress commerceAddress) throws PortalException {
        this.checkPermission(commerceAddress.getClassName(), commerceAddress.getClassPK());
    }

    protected void checkPermission(String className, long classPK) throws PortalException {
        if (className.equals(CommerceOrder.class.getName())) {
            this.commerceOrderService.getCommerceOrder(classPK);
        } else if (className.equals(AccountEntry.class.getName()) || className.equals(CommerceAccount.class.getName())) {
            this._commerceAccountService.getCommerceAccount(classPK);
        }
    }
}

