/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.FilterBuilders;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommerceOrderIndexer
extends BaseIndexer<CommerceOrder> {
    public static final String CLASS_NAME = CommerceOrder.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderIndexer.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private FilterBuilders _filterBuilders;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _modelResourcePermission;

    public CommerceOrderIndexer() {
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._modelResourcePermission.contains(permissionChecker, entryClassPK, actionId);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        int[] orderStatuses;
        long[] commerceAccountIds;
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds == null || groupIds.length == 0) {
            contextBooleanFilter.addTerm("groupId", "-1", BooleanClauseOccur.MUST);
        }
        if ((commerceAccountIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountIds"), null)) != null) {
            BooleanFilter commerceAccountIdBooleanFilter = new BooleanFilter();
            for (long commerceAccountId : commerceAccountIds) {
                TermFilter termFilter = new TermFilter("commerceAccountId", String.valueOf(commerceAccountId));
                commerceAccountIdBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            }
            commerceAccountIdBooleanFilter.add((Filter)new MissingFilter("commerceAccountId"), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)commerceAccountIdBooleanFilter, BooleanClauseOccur.MUST);
        }
        if ((orderStatuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("orderStatuses"), null)) != null) {
            BooleanFilter orderStatusesBooleanFilter = new BooleanFilter();
            int[] nArray = orderStatuses;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long orderStatus = nArray[i];
                TermFilter termFilter = new TermFilter("orderStatus", String.valueOf(orderStatus));
                orderStatusesBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            }
            orderStatusesBooleanFilter.add((Filter)new MissingFilter("orderStatus"), BooleanClauseOccur.SHOULD);
            if (GetterUtil.getBoolean((Object)searchContext.getAttribute("negateOrderStatuses"))) {
                contextBooleanFilter.add((Filter)orderStatusesBooleanFilter, BooleanClauseOccur.MUST_NOT);
            } else {
                contextBooleanFilter.add((Filter)orderStatusesBooleanFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        super.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "purchaseOrderNumber", false);
        this.addSearchTerm(searchQuery, searchContext, "externalReferenceCode", false);
        String keywords = searchContext.getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            try {
                keywords = StringUtil.toLowerCase((String)keywords);
                searchQuery.add((Query)this._getTrailingWildcardQuery("entryClassPK", keywords), BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    protected void doDelete(CommerceOrder commerceOrder) throws Exception {
        this.deleteDocument(commerceOrder.getCompanyId(), commerceOrder.getCommerceOrderId());
    }

    protected Document doGetDocument(CommerceOrder commerceOrder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing order item " + commerceOrder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceOrder);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        document.addNumberSortable("entryClassPK", Long.valueOf(commerceOrder.getCommerceOrderId()));
        document.addKeyword("status", commerceOrder.getStatus());
        document.addKeyword("advanceStatus", commerceOrder.getAdvanceStatus());
        document.addKeyword("commerceAccountId", commerceOrder.getCommerceAccountId());
        document.addKeyword("commerceChannelId", commerceChannel.getCommerceChannelId());
        document.addNumber("itemsQuantity", this._getItemsQuantity(commerceOrder));
        document.addKeyword("orderStatus", commerceOrder.getOrderStatus());
        document.addKeyword("purchaseOrderNumber", commerceOrder.getPurchaseOrderNumber());
        document.addKeyword("externalReferenceCode", commerceOrder.getExternalReferenceCode());
        document.addNumber("total", commerceOrder.getTotal());
        document.addDate("orderDate", commerceOrder.getOrderDate());
        document.addDateSortable("orderDate", commerceOrder.getOrderDate());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceOrder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(CommerceOrder commerceOrder) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceOrder.getCompanyId(), this.getDocument(commerceOrder), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceOrderLocalService.getCommerceOrder(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexCommerceOrders(companyId);
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        Boolean useSearchResultPermissionFilter = (Boolean)searchContext.getAttribute("useSearchResultPermissionFilter");
        if (useSearchResultPermissionFilter != null) {
            return useSearchResultPermissionFilter;
        }
        return super.isUseSearchResultPermissionFilter(searchContext);
    }

    private int _getItemsQuantity(CommerceOrder commerceOrder) {
        int count = 0;
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            count += commerceOrderItem.getQuantity();
        }
        return count;
    }

    private WildcardQuery _getTrailingWildcardQuery(String field, String value) {
        return new WildcardQueryImpl(field, value + "*");
    }

    private void _reindexCommerceOrders(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceOrderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceOrder -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceOrder)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce order item " + commerceOrder.getCommerceOrderId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

