/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentInactiveWarehouseException;
import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.base.CommerceShipmentItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;
import java.util.Map;

public class CommerceShipmentItemLocalServiceImpl
extends CommerceShipmentItemLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemLocalServiceImpl.class);
    @ServiceReference(type=CommerceInventoryBookedQuantityLocalService.class)
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @ServiceReference(type=CommerceInventoryEngine.class)
    private CommerceInventoryEngine _commerceInventoryEngine;
    @ServiceReference(type=CommerceInventoryWarehouseItemLocalService.class)
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @ServiceReference(type=CommerceInventoryWarehouseLocalService.class)
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addCommerceShipmentItem(String externalReferenceCode, long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, int quantity, boolean validateInventory, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        if (validateInventory) {
            this.validate(commerceOrderItem, this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId), commerceInventoryWarehouseId, quantity, quantity);
        }
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        commerceShipmentItem.setExternalReferenceCode(externalReferenceCode);
        commerceShipmentItem.setGroupId(groupId);
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), commerceShipmentItem.getQuantity());
        this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), quantity);
        return commerceShipmentItem;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addDeliverySubscriptionCommerceShipmentItem(long groupId, long userId, long commerceShipmentId, long commerceOrderItemId) throws PortalException {
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        commerceShipmentItem.setGroupId(groupId);
        User user = this.userLocalService.getUser(userId);
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        return (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
    }

    public CommerceShipmentItem addOrUpdateCommerceShipmentItem(String externalReferenceCode, long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, int quantity, boolean validateInventory, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceShipmentItem commerceShipmentItem = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceShipmentItem = this.commerceShipmentItemPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (commerceShipmentItem == null) {
            return this.commerceShipmentItemLocalService.addCommerceShipmentItem(externalReferenceCode, commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId, quantity, validateInventory, serviceContext);
        }
        return this.commerceShipmentItemLocalService.updateCommerceShipmentItem(commerceShipmentItem.getCommerceShipmentItemId(), commerceInventoryWarehouseId, quantity, validateInventory);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipmentItem deleteCommerceShipmentItem(CommerceShipmentItem commerceShipmentItem, boolean restoreStockQuantity) throws PortalException {
        this.commerceShipmentItemPersistence.remove((BaseModel)commerceShipmentItem);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        if (!restoreStockQuantity) {
            if (commerceOrderItem != null) {
                this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId(), 0L);
            }
            return commerceShipmentItem;
        }
        int shippedQuantity = Math.negateExact(commerceShipmentItem.getQuantity());
        try {
            commerceOrderItem = this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), shippedQuantity);
            if (commerceShipmentItem.getCommerceInventoryWarehouseId() > 0L && commerceShipmentItem.getQuantity() > 0) {
                this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem, commerceShipmentItem.getQuantity());
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return commerceShipmentItem;
    }

    public void deleteCommerceShipmentItem(long commerceShipmentItemId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
    }

    public void deleteCommerceShipmentItems(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        List commerceShipmentItems = this.commerceShipmentItemPersistence.findByCommerceShipmentId(commerceShipmentId);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
        }
    }

    public CommerceShipmentItem fetchCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) {
        return this.commerceShipmentItemPersistence.fetchByC_C_C(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId);
    }

    @Deprecated
    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) {
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByCommerceShipmentId(commerceShipmentId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByC_C(commerceShipmentId, commerceOrderItemId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItemsByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceShipmentItemPersistence.findByCommerceOrderItemId(commerceOrderItemId);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) {
        return this.commerceShipmentItemPersistence.countByCommerceShipmentId(commerceShipmentId);
    }

    public int getCommerceShipmentItemsCountByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceShipmentItemPersistence.countByCommerceOrderItemId(commerceOrderItemId);
    }

    public int getCommerceShipmentOrderItemsQuantity(long commerceShipmentId, long commerceOrderItemId) {
        return this.commerceShipmentItemFinder.getCommerceShipmentOrderItemsQuantity(commerceShipmentId, commerceOrderItemId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, long commerceInventoryWarehouseId, int quantity, boolean validateInventory) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        int originalQuantity = commerceShipmentItem.getQuantity();
        if (validateInventory) {
            this.validate(commerceOrderItem, commerceShipmentItem.getCommerceShipment(), commerceInventoryWarehouseId, originalQuantity, quantity);
        }
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        int quantityDelta = quantity - originalQuantity;
        if (commerceOrderItem.getQuantity() == commerceOrderItem.getShippedQuantity()) {
            this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem, Math.abs(quantityDelta));
        } else {
            this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), quantityDelta);
        }
        this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), quantityDelta);
        return commerceShipmentItem;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateExternalReferenceCode(long commerceShipmentItemId, String externalReferenceCode) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        commerceShipmentItem.setExternalReferenceCode(externalReferenceCode);
        return (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
    }

    protected void validate(CommerceOrderItem commerceOrderItem, CommerceShipment commerceShipment, long commerceInventoryWarehouseId, int quantity, int newQuantity) throws PortalException {
        if (commerceShipment != null && commerceShipment.getStatus() != 0) {
            throw new CommerceShipmentStatusException();
        }
        if (commerceInventoryWarehouseId <= 0L) {
            return;
        }
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        if (!commerceInventoryWarehouse.isActive()) {
            throw new CommerceShipmentInactiveWarehouseException();
        }
        int availableQuantity = commerceOrderItem.getQuantity() - commerceOrderItem.getShippedQuantity();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.fetchByC_C_C(commerceShipment.getCommerceShipmentId(), commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (commerceShipmentItem != null) {
            availableQuantity += commerceShipmentItem.getQuantity();
        }
        int commerceInventoryWarehouseQuantity = this.commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (newQuantity > quantity && newQuantity > availableQuantity || newQuantity > commerceInventoryWarehouseQuantity) {
            throw new CommerceShipmentItemQuantityException();
        }
    }

    private CommerceInventoryWarehouseItem _fetchCommerceInventoryWarehouseItem(long commerceShipmentItemId, String sku) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceShipmentItem.getCommerceInventoryWarehouseId(), sku);
    }

    private void _restoreStockQuantity(CommerceOrderItem commerceOrderItem, CommerceShipmentItem commerceShipmentItem, int quantity) throws PortalException {
        this._commerceInventoryEngine.increaseStockQuantity(commerceShipmentItem.getUserId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), commerceOrderItem.getSku(), quantity);
        this._commerceInventoryBookedQuantityLocalService.resetCommerceBookedQuantity(commerceOrderItem.getBookedQuantityId(), commerceOrderItem.getUserId(), commerceOrderItem.getSku(), quantity, null, (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).put((Object)"shipmentId", (Object)String.valueOf(commerceShipmentItem.getCommerceShipmentId())).build());
    }

    private void _updateStockQuantity(CommerceOrderItem commerceOrderItem, long commerceShipmentItemId, int quantity) throws PortalException {
        if (commerceOrderItem == null) {
            return;
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._fetchCommerceInventoryWarehouseItem(commerceShipmentItemId, commerceOrderItem.getSku());
        if (commerceInventoryWarehouseItem == null) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        this._commerceInventoryEngine.consumeQuantity(commerceShipmentItem.getUserId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), commerceOrderItem.getSku(), quantity, commerceOrderItem.getBookedQuantityId(), (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).put((Object)"shipmentId", (Object)String.valueOf(commerceShipmentItem.getCommerceShipmentId())).put((Object)"shipmentItemId", (Object)String.valueOf(commerceShipmentItemId)).build());
    }
}

