/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.events;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=false, property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class CommerceContextPreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextPreAction.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceContextFactory _commerceContextFactory;
    @Reference
    private GroupLocalService _groupLocalService;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block2: {
            CommerceContext commerceContext = this._commerceContextFactory.create(httpServletRequest);
            httpServletRequest.setAttribute("COMMERCE_CONTEXT", (Object)commerceContext);
            try {
                CommerceGroupThreadLocal.set((Group)this._groupLocalService.fetchGroup(commerceContext.getCommerceChannelGroupId()));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
    }
}

