/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v8_1_1;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;

/**
 * @author Brian I. Kim
 */
public class CommerceAddressUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		long commerceAccountEntryClassNameId = PortalUtil.getClassNameId(
			CommerceAccount.class.getName());
		long accountEntryClassNameId = PortalUtil.getClassNameId(
			AccountEntry.class.getName());

		runSQL(
			StringBundler.concat(
				"update Address set classNameId = ", accountEntryClassNameId,
				" where classNameId = ", commerceAccountEntryClassNameId));
	}

}