/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v4_9_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;

/**
 * @author Riccardo Alberti
 */
public class CommerceOrderUpgradeProcess
	extends BaseCommerceServiceUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		addColumn("CommerceOrder", "subtotalWithTaxAmount", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "subtotalDiscountWithTaxAmount", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "subtotalDiscountPctLev1WithTax",
			"DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "subtotalDiscountPctLev2WithTax",
			"DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "subtotalDiscountPctLev3WithTax",
			"DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "subtotalDiscountPctLev4WithTax",
			"DECIMAL(30,16)");

		addColumn("CommerceOrder", "shippingWithTaxAmount", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "shippingDiscountWithTaxAmount", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "shippingDiscountPctLev1WithTax",
			"DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "shippingDiscountPctLev2WithTax",
			"DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "shippingDiscountPctLev3WithTax",
			"DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "shippingDiscountPctLev4WithTax",
			"DECIMAL(30,16)");

		addColumn("CommerceOrder", "totalWithTaxAmount", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "totalDiscountWithTaxAmount", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "totalDiscountPctLev1WithTax", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "totalDiscountPctLev2WithTax", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "totalDiscountPctLev3WithTax", "DECIMAL(30,16)");

		addColumn(
			"CommerceOrder", "totalDiscountPctLev4WithTax", "DECIMAL(30,16)");
	}

}