/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.configuration.CommerceOrderCheckoutConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.internal.order.VersionCommerceOrderValidatorImpl;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.CommerceCheckoutStep;
import com.liferay.commerce.util.CommerceCheckoutStepServicesTracker;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceOrderHttpHelper.class})
public class CommerceOrderHttpHelperImpl
implements CommerceOrderHttpHelper {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderHttpHelperImpl.class);
    private static ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    private static final ThreadLocal<CommerceOrder> _commerceOrderThreadLocal;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCheckoutStepServicesTracker _commerceCheckoutStepServicesTracker;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;

    public CommerceOrder addCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceAccount commerceAccount;
        CommerceContext commerceContext = this._getCommerceContext(httpServletRequest);
        CommerceOrder commerceOrder = null;
        long commerceCurrencyId = 0L;
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (commerceCurrency != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        if ((commerceAccount = commerceContext.getCommerceAccount()) != null) {
            commerceOrder = this._commerceOrderService.addCommerceOrder(commerceContext.getCommerceChannelGroupId(), commerceAccount.getCommerceAccountId(), commerceCurrencyId, 0L);
        }
        if (commerceAccount == null) {
            throw new CommerceOrderValidatorException(Collections.singletonList(new CommerceOrderValidatorResult(false, this._getLocalizedMessage(this._portal.getLocale(httpServletRequest), "please-select-a-valid-account"))));
        }
        this.setCurrentCommerceOrder(httpServletRequest, commerceOrder);
        return commerceOrder;
    }

    public void deleteCommerceOrder(ActionRequest actionRequest, long commerceOrderId) throws PortalException {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        httpServletRequest.removeAttribute("COMMERCE_ORDER");
        HttpSession httpSession = httpServletRequest.getSession();
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        httpSession.removeAttribute(CommerceOrder.class.getName() + "#" + commerceOrder.getGroupId());
        this._commerceOrderService.deleteCommerceOrder(commerceOrderId);
    }

    public PortletURL getCommerceCartPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        return this.getCommerceCartPortletURL(httpServletRequest, commerceOrder);
    }

    public PortletURL getCommerceCartPortletURL(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        return this.getCommerceCartPortletURL(groupId, httpServletRequest, commerceOrder);
    }

    public PortletURL getCommerceCartPortletURL(long groupId, HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
        if (plid > 0L && commerceOrder != null && !commerceOrder.isOpen()) {
            PortletURL portletURL = this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "/commerce_order_content/view_commerce_order_details");
                portletURL.setParameter("commerceOrderUuid", String.valueOf(commerceOrder.getUuid()));
                portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrder.getCommerceOrderId()));
            }
            return portletURL;
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        if (plid > 0L) {
            return this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
        if (plid > 0L && commerceOrder != null && commerceOrder.isOpen()) {
            PortletURL portletURL = this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "/commerce_open_order_content/edit_commerce_order");
                portletURL.setParameter("commerceOrderUuid", String.valueOf(commerceOrder.getUuid()));
            }
            return portletURL;
        }
        return null;
    }

    public PortletURL getCommerceCheckoutPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        LiferayPortletURL portletURL = (LiferayPortletURL)this._getPortletURL(httpServletRequest, "com_liferay_commerce_checkout_web_internal_portlet_CommerceCheckoutPortlet");
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder == null) {
            return portletURL;
        }
        httpServletRequest.setAttribute("COMMERCE_ORDER", (Object)commerceOrder);
        if (commerceOrder.isEmpty()) {
            return portletURL;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String checkoutStepName = "";
        try {
            List commerceCheckoutSteps = this._commerceCheckoutStepServicesTracker.getCommerceCheckoutSteps(httpServletRequest, themeDisplay.getResponse());
            if (commerceCheckoutSteps != null && !commerceCheckoutSteps.isEmpty()) {
                CommerceCheckoutStep commerceCheckoutStep = (CommerceCheckoutStep)commerceCheckoutSteps.get(0);
                checkoutStepName = commerceCheckoutStep.getName();
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new PortalException((Throwable)exception);
        }
        portletURL.setParameter("checkoutStepName", checkoutStepName);
        portletURL.setParameter("commerceOrderUuid", commerceOrder.getUuid());
        try {
            portletURL.setWindowState(LiferayWindowState.NORMAL);
        }
        catch (WindowStateException windowStateException) {
            _log.error((Object)windowStateException, (Throwable)windowStateException);
            throw new PortalException((Throwable)windowStateException);
        }
        if (commerceOrder.getCommerceAccountId() == -1L) {
            LiferayPortletURL checkoutPortletURL = portletURL;
            Layout currentLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            String friendlyURL = "/authentication";
            Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(this._portal.getScopeGroupId(httpServletRequest), false, friendlyURL);
            if (!friendlyURL.equals(currentLayout.getFriendlyURL()) && layout != null) {
                portletURL = this._portletURLFactory.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", layout, "RENDER_PHASE");
            } else {
                portletURL.setParameter("continueAsGuest", Boolean.TRUE.toString());
                Cookie cookie = new Cookie("COMMERCE_CONTINUE_AS_GUEST", Boolean.TRUE.toString());
                String domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest);
                if (Validator.isNotNull((String)domain)) {
                    cookie.setDomain(domain);
                }
                cookie.setMaxAge(31536000);
                cookie.setPath("/");
                CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)themeDisplay.getResponse(), (Cookie)cookie);
            }
            portletURL.setParameter("redirect", checkoutPortletURL.toString());
        }
        return portletURL;
    }

    public int getCommerceOrderItemsQuantity(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder == null) {
            return 0;
        }
        return this._commerceOrderItemService.getCommerceOrderItemsQuantity(commerceOrder.getCommerceOrderId());
    }

    public String getCookieName(long groupId) {
        return CommerceOrder.class.getName() + "#" + groupId;
    }

    public CommerceOrder getCurrentCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceContext commerceContext = (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount == null) {
            return null;
        }
        CommerceOrder commerceOrder = this._getCurrentCommerceOrder(commerceContext, httpServletRequest);
        if (commerceOrder != null) {
            if (commerceOrder.isGuestOrder()) {
                commerceOrder = this._checkGuestOrder(commerceContext, commerceOrder, httpServletRequest);
            } else if (commerceOrder.getCommerceAccountId() != commerceAccount.getCommerceAccountId()) {
                return null;
            }
        }
        if (commerceOrder != null && !commerceOrder.isOpen() || commerceOrder != null && !_commerceOrderModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE")) {
            return null;
        }
        return commerceOrder;
    }

    public boolean isGuestCheckoutEnabled(HttpServletRequest httpServletRequest) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        CommerceOrderCheckoutConfiguration commerceOrderCheckoutConfiguration = (CommerceOrderCheckoutConfiguration)this._configurationProvider.getConfiguration(CommerceOrderCheckoutConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.order"));
        return commerceOrderCheckoutConfiguration.guestCheckoutEnabled();
    }

    public void setCurrentCommerceOrder(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        commerceOrder = this._commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest));
        if (!themeDisplay.isSignedIn()) {
            this._setGuestCommerceOrder(commerceOrder, themeDisplay);
            return;
        }
        httpServletRequest.setAttribute("COMMERCE_ORDER", (Object)commerceOrder);
        httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute(this.getCookieName(commerceOrder.getGroupId()), (Object)commerceOrder.getUuid());
    }

    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<CommerceOrder> modelResourcePermission) {
        _commerceOrderModelResourcePermission = modelResourcePermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommerceOrder _checkGuestOrder(CommerceContext commerceContext, CommerceOrder commerceOrder, HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder userCommerceOrder;
        if (commerceOrder == null) {
            return null;
        }
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount == null) {
            return null;
        }
        User user = this._portal.getUser(httpServletRequest);
        if (user == null || user.isDefaultUser()) {
            return commerceOrder;
        }
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        String cookieName = this.getCookieName(commerceOrder.getGroupId());
        CommerceOrder threadLocalCommerceOrder = _commerceOrderThreadLocal.get();
        if (threadLocalCommerceOrder != null && threadLocalCommerceOrder.isGuestOrder()) {
            httpSession.removeAttribute(cookieName);
            _commerceOrderThreadLocal.remove();
        }
        if ((userCommerceOrder = this._commerceOrderService.fetchCommerceOrder(commerceAccount.getCommerceAccountId(), commerceContext.getCommerceChannelGroupId(), user.getUserId(), 2)) == null) {
            httpSession.removeAttribute(cookieName);
            return this._commerceOrderLocalService.updateAccount(commerceOrder.getCommerceOrderId(), user.getUserId(), commerceAccount.getCommerceAccountId());
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        _commerceOrderThreadLocal.set(userCommerceOrder);
        try {
            this._commerceOrderLocalService.mergeGuestCommerceOrder(commerceOrder.getCommerceOrderId(), userCommerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest), serviceContext);
        }
        finally {
            _commerceOrderThreadLocal.remove();
        }
        httpSession.removeAttribute(cookieName);
        return userCommerceOrder;
    }

    private String _fetchCommerceOrderUuid(CommerceChannel commerceChannel, HttpServletRequest httpServletRequest) {
        String cookieName;
        if (commerceChannel == null) {
            return null;
        }
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        String commerceOrderUuid = (String)httpSession.getAttribute(cookieName = this.getCookieName(commerceChannel.getGroupId()));
        if (Validator.isNull((String)commerceOrderUuid)) {
            commerceOrderUuid = CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)cookieName, (boolean)true);
        }
        return commerceOrderUuid;
    }

    private CommerceContext _getCommerceContext(HttpServletRequest httpServletRequest) {
        return (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
    }

    private CommerceOrder _getCurrentCommerceOrder(CommerceContext commerceContext, HttpServletRequest httpServletRequest) throws PortalException {
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        String commerceOrderUuid = this._fetchCommerceOrderUuid(commerceChannel, httpServletRequest);
        CommerceOrder commerceOrder = _commerceOrderThreadLocal.get();
        if (commerceOrder != null) {
            CommerceOrder persistedCommerceOrder = this._commerceOrderLocalService.fetchCommerceOrder(commerceOrder.getCommerceOrderId());
            if (persistedCommerceOrder != null) {
                commerceOrder = persistedCommerceOrder;
                _commerceOrderThreadLocal.set(persistedCommerceOrder);
            }
            if (commerceAccount == null || commerceAccount.getCommerceAccountId() == -1L || Validator.isNotNull((String)commerceOrderUuid) && commerceOrderUuid.equals(commerceOrder.getUuid()) && commerceAccount.getCommerceAccountId() == commerceOrder.getCommerceAccountId()) {
                return commerceOrder;
            }
        }
        if (commerceAccount == null || commerceChannel == null) {
            return null;
        }
        if (commerceAccount.getCommerceAccountId() != -1L) {
            commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannel.getGroupId());
            if (commerceOrder == null || !commerceOrder.isGuestOrder() && commerceAccount.getCommerceAccountId() != commerceOrder.getCommerceAccountId()) {
                commerceOrder = this._commerceOrderService.fetchCommerceOrder(commerceAccount.getCommerceAccountId(), commerceChannel.getGroupId(), this._portal.getUserId(httpServletRequest), 2);
            }
            if (commerceOrder != null) {
                this._validateCommerceOrderItemVersions(commerceOrder, this._portal.getLocale(httpServletRequest));
                _commerceOrderThreadLocal.set(commerceOrder);
                return commerceOrder;
            }
        }
        if (Validator.isNotNull((String)commerceOrderUuid) && (commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannel.getGroupId())) != null) {
            _commerceOrderThreadLocal.set(commerceOrder);
        }
        return commerceOrder;
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        if (locale == null) {
            return key;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)key);
    }

    private PortletURL _getPortletURL(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        return this._getPortletURL(groupId, httpServletRequest, portletId);
    }

    private PortletURL _getPortletURL(long groupId, HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        LiferayPortletURL portletURL = null;
        long plid = this._portal.getPlidFromPortletId(groupId, portletId);
        portletURL = plid > 0L ? this._portletURLFactory.create(httpServletRequest, portletId, plid, "RENDER_PHASE") : this._portletURLFactory.create(httpServletRequest, portletId, "RENDER_PHASE");
        return portletURL;
    }

    private void _setGuestCommerceOrder(CommerceOrder commerceOrder, ThemeDisplay themeDisplay) throws PortalException {
        User user = themeDisplay.getUser();
        if (user != null && !user.isDefaultUser()) {
            return;
        }
        long commerceChannelGroupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(themeDisplay.getScopeGroupId());
        Cookie cookie = new Cookie(this.getCookieName(commerceChannelGroupId), commerceOrder.getUuid());
        String domain = CookieKeys.getDomain((HttpServletRequest)themeDisplay.getRequest());
        if (Validator.isNotNull((String)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)themeDisplay.getRequest(), (HttpServletResponse)themeDisplay.getResponse(), (Cookie)cookie);
    }

    private void _validateCommerceOrderItemVersions(CommerceOrder commerceOrder, Locale locale) throws PortalException {
        VersionCommerceOrderValidatorImpl versionCommerceOrderValidatorImpl = new VersionCommerceOrderValidatorImpl();
        versionCommerceOrderValidatorImpl.setCommerceOrderItemLocalService(this._commerceOrderItemLocalService);
        versionCommerceOrderValidatorImpl.setCPInstanceLocalService(this._cpInstanceLocalService);
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            versionCommerceOrderValidatorImpl.validate(locale, commerceOrderItem);
        }
    }

    static {
        _commerceOrderThreadLocal = new CentralizedThreadLocal(CommerceOrderHttpHelperImpl.class.getName());
    }
}

