/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.helper;

import com.liferay.commerce.constants.CommerceSAPConstants;
import com.liferay.commerce.helper.CommerceSAPHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceSAPHelper.class})
public class CommerceSAPHelperImpl
implements CommerceSAPHelper {
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;

    public void addCommerceDefaultSAPEntries(long companyId, long userId) throws PortalException {
        for (String[] sapEntryObjectArray : CommerceSAPConstants.SAP_ENTRY_OBJECT_ARRAYS) {
            String sapEntryName = sapEntryObjectArray[0];
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, sapEntryName);
            if (sapEntry != null) continue;
            Map titleMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER, (String)"public-access-to-the-commerce-service-apis");
            this._sapEntryLocalService.addSAPEntry(userId, sapEntryObjectArray[1], true, true, sapEntryName, titleMap, new ServiceContext());
        }
    }

    public void removeCommerceDefaultSAPEntries(long companyId) throws PortalException {
        List companySAPEntries = this._sapEntryLocalService.getCompanySAPEntries(companyId, -1, -1);
        for (SAPEntry sapEntry : companySAPEntries) {
            if (!Objects.equals(sapEntry.getName(), "COMMERCE_DEFAULT")) continue;
            this._sapEntryLocalService.deleteSAPEntry(sapEntry);
        }
    }
}

