/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v4_1_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.model.impl.CommerceAddressImpl;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class CommerceAddressUpgradeProcess
extends BaseCommerceServiceUpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;

    public CommerceAddressUpgradeProcess(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("CommerceAccount", "defaultBillingAddressId") || !this.hasColumn("CommerceAccount", "defaultShippingAddressId")) {
            throw new UpgradeException("Upgrade fails as CommerceAccount does not have both columns: 'defaultBillingAddressId' and'defaultShippingAddressId'");
        }
        this.addColumn(CommerceAddressImpl.class, "CommerceAddress", "type_", "INTEGER");
        PreparedStatement preparedStatement = null;
        if (this.hasColumn("CommerceAddress", "defaultBilling")) {
            preparedStatement = this.connection.prepareStatement("update CommerceAccount set defaultBillingAddressId = ? where commerceAccountId = ?");
            this._updateCommerceAccountAndSetType(preparedStatement, this._getCommerceAddressResultSet("defaultBilling"));
        }
        if (this.hasColumn("CommerceAddress", "defaultShipping")) {
            preparedStatement = this.connection.prepareStatement("update CommerceAccount set defaultShippingAddressId = ? where commerceAccountId = ?");
            this._updateCommerceAccountAndSetType(preparedStatement, this._getCommerceAddressResultSet("defaultShipping"));
        }
    }

    private ResultSet _getCommerceAddressResultSet(String type) throws Exception {
        long commerceAccountClassNameId = this._classNameLocalService.getClassNameId(CommerceAccount.class);
        PreparedStatement preparedStatement = null;
        preparedStatement = type.equals("defaultBilling") ? this.connection.prepareStatement(SQLTransformer.transform((String)"select commerceAddressId, classPK, defaultBilling, defaultShipping from CommerceAddress where classNameId = ? and defaultBilling = [$TRUE$]")) : this.connection.prepareStatement(SQLTransformer.transform((String)"select commerceAddressId, classPK, defaultBilling, defaultShipping from CommerceAddress where classNameId = ? and defaultShipping = [$TRUE$]"));
        preparedStatement.setLong(1, commerceAccountClassNameId);
        return preparedStatement.executeQuery();
    }

    private void _setType(boolean defaultBilling, boolean defaultShipping, long commerceAddressId) throws Exception {
        PreparedStatement preparedStatement = this.connection.prepareStatement("update CommerceAddress set type_ = ? where commerceAddressId = ?");
        int type = 3;
        if (defaultBilling && !defaultShipping) {
            type = 1;
        } else if (!defaultBilling && defaultShipping) {
            type = 3;
        }
        preparedStatement.setInt(1, type);
        preparedStatement.setLong(2, commerceAddressId);
        preparedStatement.addBatch();
    }

    private void _updateCommerceAccountAndSetType(PreparedStatement preparedStatement, ResultSet resultSet) throws Exception {
        while (resultSet.next()) {
            long commerceAddressId = resultSet.getLong("commerceAddressId");
            preparedStatement.setLong(1, commerceAddressId);
            preparedStatement.setLong(2, resultSet.getLong("classPK"));
            this._setType(resultSet.getBoolean("defaultBilling"), resultSet.getBoolean("defaultShipping"), commerceAddressId);
            preparedStatement.addBatch();
        }
    }
}

