/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceMessagingConfigurator.class})
public class CommerceMessagingConfigurator {
    private volatile ServiceRegistration<Destination> _basePriceListServiceRegistration;
    @Reference
    private DestinationFactory _destinationFactory;
    private volatile ServiceRegistration<Destination> _orderStatusServiceRegistration;
    private volatile ServiceRegistration<Destination> _paymentStatusServiceRegistration;
    private volatile ServiceRegistration<Destination> _shipmentStatusServiceRegistration;
    private volatile ServiceRegistration<Destination> _subscriptionStatusServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._basePriceListServiceRegistration = this._registerDestination(bundleContext, "liferay/commerce_base_price_list", CommercePriceList.class.getName());
        this._orderStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/commerce_order_status", CommerceOrder.class.getName());
        this._paymentStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/commerce_payment_status", CommerceOrder.class.getName());
        this._shipmentStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/commerce_shipment_status", CommerceShipment.class.getName());
        this._subscriptionStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/commerce_subscription_status", CommerceOrder.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        if (this._basePriceListServiceRegistration != null) {
            this._basePriceListServiceRegistration.unregister();
        }
        if (this._orderStatusServiceRegistration != null) {
            this._orderStatusServiceRegistration.unregister();
        }
        if (this._paymentStatusServiceRegistration != null) {
            this._paymentStatusServiceRegistration.unregister();
        }
        if (this._shipmentStatusServiceRegistration != null) {
            this._shipmentStatusServiceRegistration.unregister();
        }
        if (this._subscriptionStatusServiceRegistration != null) {
            this._subscriptionStatusServiceRegistration.unregister();
        }
    }

    private ServiceRegistration<Destination> _registerDestination(BundleContext bundleContext, String destinationName, String className) {
        DestinationConfiguration destinationConfiguration = DestinationConfiguration.createParallelDestinationConfiguration((String)destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).put((Object)"object.action.trigger.class.name", (Object)className).build();
        return bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
    }
}

