/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v7_2_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.model.impl.CommerceOrderTypeModelImpl;
import com.liferay.commerce.model.impl.CommerceOrderTypeRelModelImpl;

/**
 * @author Riccardo Alberti
 * @author Alessio Antonio Rendina
 */
public class CommerceOrderTypeUpgradeProcess
	extends BaseCommerceServiceUpgradeProcess {

	@Override
	public void doUpgrade() throws Exception {
		if (!hasTable(CommerceOrderTypeModelImpl.TABLE_NAME)) {
			runSQL(CommerceOrderTypeModelImpl.TABLE_SQL_CREATE);
		}

		if (!hasTable(CommerceOrderTypeRelModelImpl.TABLE_NAME)) {
			runSQL(CommerceOrderTypeRelModelImpl.TABLE_SQL_CREATE);
		}
	}

}