/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.notification.type;

import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.language.LanguageUtil;

import java.util.Locale;

/**
 * @author Marco Leo
 */
public class ObjectDefinitionCommerceNotificationType
	implements CommerceNotificationType {

	public ObjectDefinitionCommerceNotificationType(
		String action, String key, String label) {

		_action = action;
		_key = key;
		_label = label;
	}

	@Override
	public String getClassName(Object object) {
		if (!(object instanceof ObjectEntry)) {
			return null;
		}

		return ObjectEntry.class.getName();
	}

	@Override
	public long getClassPK(Object object) {
		if (!(object instanceof ObjectEntry)) {
			return 0;
		}

		ObjectEntry objectEntry = (ObjectEntry)object;

		return objectEntry.getObjectEntryId();
	}

	@Override
	public String getKey() {
		return _key;
	}

	@Override
	public String getLabel(Locale locale) {
		return _label + " # " + LanguageUtil.get(locale, _action);
	}

	private final String _action;
	private final String _key;
	private final String _label;

}