/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.permission.CommerceAccountPermission;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.base.CommerceOrderItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class CommerceOrderItemServiceImpl
extends CommerceOrderItemServiceBaseImpl {
    @ServiceReference(type=CommerceAccountPermission.class)
    protected CommerceAccountPermission commerceAccountPermission;
    @ServiceReference(type=CommerceProductViewPermission.class)
    protected CommerceProductViewPermission commerceProductViewPermission;
    @ServiceReference(type=CPInstanceLocalService.class)
    protected CPInstanceLocalService cpInstanceLocalService;
    private static volatile ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceOrderItemServiceImpl.class, (String)"_commerceOrderModelResourcePermission", CommerceOrder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceOrderItemServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce.order");

    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, String json, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderItemLocalService.addCommerceOrderItem(commerceOrderId, cpInstanceId, json, quantity, shippedQuantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem addOrUpdateCommerceOrderItem(long commerceOrderId, long cpInstanceId, String json, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        CommerceOrder commerceOrder = this.commerceOrderService.getCommerceOrder(commerceOrderId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE");
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this.commerceProductViewPermission.check(this.getPermissionChecker(), commerceAccount.getCommerceAccountId(), commerceOrder.getGroupId(), cpInstance.getCPDefinitionId());
        return this.commerceOrderItemLocalService.addOrUpdateCommerceOrderItem(commerceOrderId, cpInstanceId, json, quantity, shippedQuantity, commerceContext, serviceContext);
    }

    public int countSubscriptionCommerceOrderItems(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.countSubscriptionCommerceOrderItems(commerceOrderId);
    }

    public void deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
    }

    public void deleteCommerceOrderItem(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem, commerceContext);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItems(commerceOrderId);
    }

    public CommerceOrderItem fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceOrderItem != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(commerceOrderItemId);
        if (commerceOrderItem != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return commerceOrderItem;
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
    }

    public List<CommerceOrderItem> getChildCommerceOrderItems(long parentCommerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(parentCommerceOrderItemId);
        if (commerceOrderItem != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return this.commerceOrderItemLocalService.getChildCommerceOrderItems(parentCommerceOrderItemId);
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return this.commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItemId, commerceInventoryWarehouseId);
    }

    public CommerceOrderItem getCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return commerceOrderItem;
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItems(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) throws PortalException {
        this.commerceAccountPermission.check(this.getPermissionChecker(), commerceAccountId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItems(groupId, commerceAccountId, orderStatuses, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsCount(long groupId, long commerceAccountId, int[] orderStatuses) throws PortalException {
        this.commerceAccountPermission.check(this.getPermissionChecker(), commerceAccountId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(groupId, commerceAccountId, orderStatuses);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public CommerceOrderItem importCommerceOrderItem(long commerceOrderId, long cpInstanceId, String cpMeasurementUnitKey, BigDecimal decimalQuantity, int shippedQuantity, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderItemLocalService.importCommerceOrderItem(commerceOrderId, cpInstanceId, cpMeasurementUnitKey, decimalQuantity, shippedQuantity, serviceContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, long parentCommerceOrderItemId, String keywords, int start, int end, Sort sort) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.searchCommerceOrderItems(commerceOrderId, parentCommerceOrderItemId, keywords, start, end, sort);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.searchCommerceOrderItems(commerceOrderId, keywords, start, end, sort);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String name, String sku, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.searchCommerceOrderItems(commerceOrderId, name, sku, andOperator, start, end, sort);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long cpMeasurementUnitId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, cpMeasurementUnitId, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, String json, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), json, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItemDeliveryDate(long commerceOrderItemId, Date requestedDeliveryDate) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemDeliveryDate(commerceOrderItemId, requestedDeliveryDate);
    }

    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroup, String printedNote) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote);
    }

    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroup, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderItemService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, BigDecimal finalPrice, BigDecimal promoPrice, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemPrices(commerceOrderItemId, discountAmount, discountPercentageLevel1, discountPercentageLevel2, discountPercentageLevel3, discountPercentageLevel4, finalPrice, promoPrice, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountAmountWithTaxAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel1WithTaxAmount, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel2WithTaxAmount, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel3WithTaxAmount, BigDecimal discountPercentageLevel4, BigDecimal discountPercentageLevel4WithTaxAmount, BigDecimal finalPrice, BigDecimal finalPriceWithTaxAmount, BigDecimal promoPrice, BigDecimal promoPriceWithTaxAmount, BigDecimal unitPrice, BigDecimal unitPriceWithTaxAmount) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemPrices(commerceOrderItemId, discountAmount, discountAmountWithTaxAmount, discountPercentageLevel1, discountPercentageLevel1WithTaxAmount, discountPercentageLevel2, discountPercentageLevel2WithTaxAmount, discountPercentageLevel3, discountPercentageLevel3WithTaxAmount, discountPercentageLevel4, discountPercentageLevel4WithTaxAmount, finalPrice, finalPriceWithTaxAmount, promoPrice, promoPriceWithTaxAmount, unitPrice, unitPriceWithTaxAmount);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(commerceOrderItemId, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal decimalQuantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(this.getUserId(), commerceOrderItemId, decimalQuantity, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, int quantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        _portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(this.getUserId(), commerceOrderItemId, quantity, unitPrice);
    }

    public CommerceOrderItem updateCustomFields(long commerceOrderItemId, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCustomFields(commerceOrderItemId, serviceContext);
    }
}

