/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.importer.type;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.importer.type.CommerceOrderImporterType;
import com.liferay.commerce.order.importer.type.CommerceOrderImporterTypeRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, immediate=true, service={CommerceOrderImporterTypeRegistry.class})
public class CommerceOrderImporterTypeRegistryImpl
implements CommerceOrderImporterTypeRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderImporterTypeRegistryImpl.class);
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceOrderImporterType>> _serviceTrackerMap;

    public CommerceOrderImporterType getCommerceOrderImporterType(String key) {
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceOrderImporterTypeServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceOrderImporterTypeServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce order importer type registered with key " + key));
            }
            return null;
        }
        return (CommerceOrderImporterType)commerceOrderImporterTypeServiceWrapper.getService();
    }

    public List<CommerceOrderImporterType> getCommerceOrderImporterTypes(CommerceOrder commerceOrder) throws PortalException {
        ArrayList<CommerceOrderImporterType> commerceOrderImporterTypes = new ArrayList<CommerceOrderImporterType>();
        List commerceOrderImporterTypeServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceOrderImporterTypeServiceWrapper : commerceOrderImporterTypeServiceWrappers) {
            CommerceOrderImporterType commerceOrderImporterType = (CommerceOrderImporterType)commerceOrderImporterTypeServiceWrapper.getService();
            if (!commerceOrderImporterType.isActive(commerceOrder)) continue;
            commerceOrderImporterTypes.add(commerceOrderImporterType);
        }
        return Collections.unmodifiableList(commerceOrderImporterTypes);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceOrderImporterType.class, (String)"commerce.order.importer.type.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

