/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.term.contributor;

import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.object.model.ObjectEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ObjectRecipientCommerceDefinitionTermContributor
implements CommerceDefinitionTermContributor {
    private static final Map<String, String> _languageKeys = HashMapBuilder.put((Object)"[%OBJECT_ENTRY_CREATOR%]", (Object)"creator").put((Object)"[%USER_GROUP_NAME%]", (Object)"user-group-name").build();
    private final UserGroupLocalService _userGroupLocalService;
    private final UserLocalService _userLocalService;

    public ObjectRecipientCommerceDefinitionTermContributor(UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) {
        this._userGroupLocalService = userGroupLocalService;
        this._userLocalService = userLocalService;
    }

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        ObjectEntry objectEntry = null;
        if (object instanceof ObjectEntry) {
            objectEntry = (ObjectEntry)object;
        }
        if (term.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            return String.valueOf(objectEntry.getUserId());
        }
        if (term.startsWith("[%USER_GROUP_")) {
            String[] termParts = term.split("_");
            UserGroup userGroup = this._userGroupLocalService.getUserGroup(objectEntry.getCompanyId(), StringUtil.removeChars((String)termParts[2], (char[])new char[]{'%', ']'}));
            return this._getUserIds(userGroup);
        }
        return term;
    }

    public String getLabel(String term, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)_languageKeys.get(term));
    }

    public List<String> getTerms() {
        return new ArrayList<String>(_languageKeys.keySet());
    }

    private String _getUserIds(UserGroup userGroup) throws PortalException {
        StringBundler sb = new StringBundler();
        List users = this._userLocalService.getUserGroupUsers(userGroup.getUserGroupId());
        for (User user : users) {
            sb.append(user.getUserId());
            sb.append(",");
        }
        return sb.toString();
    }
}

