/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.tax.CommerceTaxEngine;
import com.liferay.commerce.util.CommerceTaxEngineRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={CommerceTaxEngineRegistry.class})
public class CommerceTaxEngineRegistryImpl
implements CommerceTaxEngineRegistry {
    private ServiceTrackerMap<String, CommerceTaxEngine> _serviceTrackerMap;

    public CommerceTaxEngine getCommerceTaxEngine(String key) {
        return (CommerceTaxEngine)this._serviceTrackerMap.getService((Object)key);
    }

    public Map<String, CommerceTaxEngine> getCommerceTaxEngines() {
        HashMap<String, CommerceTaxEngine> commerceTaxEngines = new HashMap<String, CommerceTaxEngine>();
        for (String key : this._serviceTrackerMap.keySet()) {
            commerceTaxEngines.put(key, (CommerceTaxEngine)this._serviceTrackerMap.getService((Object)key));
        }
        return Collections.unmodifiableMap(commerceTaxEngines);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceTaxEngine.class, null, (serviceReference, emitter) -> {
            CommerceTaxEngine commerceTaxEngine = (CommerceTaxEngine)bundleContext.getService(serviceReference);
            try {
                if (commerceTaxEngine.getKey() != null) {
                    emitter.emit((Object)commerceTaxEngine.getKey());
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

