/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v7_1_2;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class CommerceAccountRoleUpgradeProcess
extends UpgradeProcess {
    private final AccountRoleLocalService _accountRoleLocalService;
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommerceAccountRoleUpgradeProcess(AccountRoleLocalService accountRoleLocalService, ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._accountRoleLocalService = accountRoleLocalService;
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select distinct UserGroupRole.ctCollectionId, ", "UserGroupRole.roleId from UserGroupRole inner join Role_ ", "on Role_.roleId = UserGroupRole.roleId inner join Group_ ", "on Group_.classNameId = '", this._classNameLocalService.getClassNameId(AccountEntry.class), "' and Group_.groupId = UserGroupRole.groupId where ", "Role_.type_ =", 2}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Role_ set classNameId = ?, classPK = ?, type_ = ? where ctCollectionId = ? and roleId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long roleId = resultSet.getLong(2);
                if (this._hasNonaccountEntryGroup(roleId)) {
                    AccountRole accountRole = this._copyToAccountRole(roleId);
                    this._updateUserGroupRole(accountRole.getRoleId(), roleId);
                    continue;
                }
                preparedStatement2.setLong(1, this._classNameLocalService.getClassNameId(AccountRole.class));
                Role role = this._roleLocalService.getRole(roleId);
                AccountRole accountRole = this._accountRoleLocalService.createAccountRole(this.increment());
                accountRole.setCompanyId(role.getCompanyId());
                accountRole.setAccountEntryId(0L);
                accountRole.setRoleId(role.getRoleId());
                accountRole = this._accountRoleLocalService.addAccountRole(accountRole);
                preparedStatement2.setLong(2, accountRole.getAccountRoleId());
                preparedStatement2.setInt(3, 6);
                preparedStatement2.setLong(4, resultSet.getLong("ctCollectionId"));
                preparedStatement2.setLong(5, roleId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _copyResourcePermission(ResourcePermission resourcePermission, long roleId) {
        ResourcePermission newResourcePermission = this._resourcePermissionLocalService.createResourcePermission(this.increment(ResourcePermission.class.getName()));
        newResourcePermission.setCompanyId(resourcePermission.getCompanyId());
        newResourcePermission.setName(resourcePermission.getName());
        newResourcePermission.setScope(resourcePermission.getScope());
        newResourcePermission.setPrimKey(resourcePermission.getPrimKey());
        newResourcePermission.setPrimKeyId(resourcePermission.getPrimKeyId());
        newResourcePermission.setRoleId(roleId);
        newResourcePermission.setOwnerId(resourcePermission.getOwnerId());
        newResourcePermission.setActionIds(resourcePermission.getActionIds());
        newResourcePermission.setViewActionId(resourcePermission.isViewActionId());
        this._resourcePermissionLocalService.addResourcePermission(newResourcePermission);
    }

    private AccountRole _copyToAccountRole(long roleId) throws Exception {
        Role role = this._roleLocalService.getRole(roleId);
        AccountRole accountRole = this._accountRoleLocalService.addAccountRole(null, role.getUserId(), 0L, role.getName() + "_Account", role.getTitleMap(), role.getDescriptionMap());
        List resourcePermissions = this._resourcePermissionLocalService.getRoleResourcePermissions(role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (resourcePermission.getScope() == 2) {
                Group group = this._groupLocalService.getGroup(Long.valueOf(resourcePermission.getPrimKey()).longValue());
                if (group.getClassNameId() != this._classNameLocalService.getClassNameId(AccountEntry.class)) continue;
                resourcePermission.setRoleId(accountRole.getRoleId());
                resourcePermission = this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
                continue;
            }
            if (resourcePermission.getScope() != 3 && resourcePermission.getScope() != 4) continue;
            this._copyResourcePermission(resourcePermission, accountRole.getRoleId());
        }
        return accountRole;
    }

    /*
     * Exception decompiling
     */
    private boolean _hasNonaccountEntryGroup(long roleId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _updateUserGroupRole(long newRoleId, long oldRoleId) throws Exception {
        DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(StringBundler.concat((Object[])new Object[]{"update UserGroupRole set roleId = ", newRoleId, " from Group_ where Group_.classNameId = '", this._classNameLocalService.getClassNameId(AccountEntry.class), "' and Group_.groupId = UserGroupRole.groupId and ", "UserGroupRole.roleId = ", oldRoleId}));
        String sql = StringBundler.concat((Object[])new Object[]{"update UserGroupRole inner join Group_ on Group_.classNameId = '", this._classNameLocalService.getClassNameId(AccountEntry.class), "' and Group_.groupId = UserGroupRole.groupId set roleId = ", newRoleId, " where roleId = ", oldRoleId});
        dbTypeToSQLMap.add(DBType.MARIADB, sql);
        dbTypeToSQLMap.add(DBType.MYSQL, sql);
        this.runSQL(dbTypeToSQLMap);
    }
}

