/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v5_9_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.helper.CommerceAccountHelper;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.function.UnaryOperator;

public class CommerceAccountUpgradeProcess
extends UpgradeProcess {
    private final AccountEntryLocalService _accountEntryLocalService;
    private final ClassNameLocalService _classNameLocalService;
    private final CommerceAccountHelper _commerceAccountHelper;
    private final ExpandoTableLocalService _expandoTableLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;
    private final GroupLocalService _groupLocalService;
    private final ResourceLocalService _resourceLocalService;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    private final WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public CommerceAccountUpgradeProcess(AccountEntryLocalService accountEntryLocalService, ClassNameLocalService classNameLocalService, CommerceAccountHelper commerceAccountHelper, ExpandoTableLocalService expandoTableLocalService, ExpandoValueLocalService expandoValueLocalService, GroupLocalService groupLocalService, ResourceLocalService resourceLocalService, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService, WorkflowInstanceLinkLocalService workflowInstanceLinkLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._classNameLocalService = classNameLocalService;
        this._commerceAccountHelper = commerceAccountHelper;
        this._expandoTableLocalService = expandoTableLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
        this._groupLocalService = groupLocalService;
        this._resourceLocalService = resourceLocalService;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
        this._workflowInstanceLinkLocalService = workflowInstanceLinkLocalService;
    }

    protected void doUpgrade() throws Exception {
        String selectCommerceAccountSQL = "select * from CommerceAccount order by commerceAccountId asc";
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectCommerceAccountSQL);
            while (resultSet.next()) {
                long accountEntryId = resultSet.getLong("commerceAccountId");
                AccountEntry accountEntry = this._accountEntryLocalService.createAccountEntry(accountEntryId);
                accountEntry.setExternalReferenceCode(resultSet.getString("externalReferenceCode"));
                long companyId = resultSet.getLong("companyId");
                accountEntry.setCompanyId(companyId);
                long userId = resultSet.getLong("userId");
                accountEntry.setUserId(userId);
                accountEntry.setUserName(resultSet.getString("userName"));
                accountEntry.setCreateDate((Date)resultSet.getTimestamp("createDate"));
                accountEntry.setModifiedDate((Date)resultSet.getTimestamp("modifiedDate"));
                accountEntry.setDefaultBillingAddressId(resultSet.getLong("defaultBillingAddressId"));
                accountEntry.setDefaultShippingAddressId(resultSet.getLong("defaultShippingAddressId"));
                accountEntry.setParentAccountEntryId(resultSet.getLong("parentCommerceAccountId"));
                accountEntry.setEmailAddress(resultSet.getString("email"));
                accountEntry.setLogoId(resultSet.getLong("logoId"));
                accountEntry.setName(resultSet.getString("name"));
                accountEntry.setTaxIdNumber(resultSet.getString("taxId"));
                accountEntry.setType(this._toAccountEntryType(resultSet.getInt("type_")));
                accountEntry.setStatus(this._commerceAccountHelper.toAccountEntryStatus(Boolean.valueOf(resultSet.getBoolean("active_"))).intValue());
                this._accountEntryLocalService.addAccountEntry(accountEntry);
                this._resourceLocalService.addResources(companyId, 0L, userId, AccountEntry.class.getName(), accountEntryId, false, false, false);
                this._workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(companyId, 0L, "com.liferay.commerce.account.model.CommerceAccount", accountEntryId, 0L);
                this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, 0L, "com.liferay.commerce.account.model.CommerceAccount", accountEntryId);
            }
        }
        long accountEntryClassNameId = this._classNameLocalService.getClassNameId(AccountEntry.class);
        long commerceAccountClassNameId = this._classNameLocalService.getClassNameId("com.liferay.commerce.account.model.CommerceAccount");
        this._updateClassNameId(this._expandoTableLocalService.getActionableDynamicQuery(), accountEntryClassNameId, commerceAccountClassNameId, typedModel -> this._expandoTableLocalService.updateExpandoTable((ExpandoTable)typedModel));
        this._updateClassNameId(this._expandoValueLocalService.getActionableDynamicQuery(), accountEntryClassNameId, commerceAccountClassNameId, typedModel -> this._expandoValueLocalService.updateExpandoValue((ExpandoValue)typedModel));
        this._updateClassNameId(this._groupLocalService.getActionableDynamicQuery(), accountEntryClassNameId, commerceAccountClassNameId, typedModel -> this._groupLocalService.updateGroup((Group)typedModel));
    }

    private String _toAccountEntryType(int commerceAccountType) {
        if (commerceAccountType == 2) {
            return "business";
        }
        if (commerceAccountType == 0) {
            return "guest";
        }
        if (commerceAccountType == 1) {
            return "person";
        }
        return null;
    }

    private void _updateClassNameId(ActionableDynamicQuery actionableDynamicQuery, long newClassNameId, long oldClassNameId, UnaryOperator<TypedModel> updateFunction) throws Exception {
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)oldClassNameId)));
        actionableDynamicQuery.setPerformActionMethod(typedModel -> {
            typedModel.setClassNameId(newClassNameId);
            updateFunction.apply((TypedModel)typedModel);
        });
        actionableDynamicQuery.performActions();
    }
}

