/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v13_0_1;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class ReturnsManagerRoleUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ReturnsManagerRoleUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public ReturnsManagerRoleUpgradeProcess(CompanyLocalService companyLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> {
            try {
                this._updateReturnsManagerPermissions(company.getCompanyId());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private void _updateReturnsManagerPermissions(long companyId) throws PortalException {
        Role returnsManagerRole = this._roleLocalService.fetchRole(companyId, "Returns Manager");
        if (returnsManagerRole != null) {
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, CommerceChannel.class.getName(), 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "UPDATE")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, CommerceChannel.class.getName(), 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "UPDATE");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, CommerceChannel.class.getName(), 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "VIEW")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, CommerceChannel.class.getName(), 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "VIEW");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com_liferay_commerce_payment_web_internal_portlet_CommercePaymentPortlet", 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "ACCESS_IN_CONTROL_PANEL")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com_liferay_commerce_payment_web_internal_portlet_CommercePaymentPortlet", 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "ACCESS_IN_CONTROL_PANEL");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.commerce.currency", 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "MANAGE_COMMERCE_CURRENCIES")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.currency", 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "MANAGE_COMMERCE_CURRENCIES");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.commerce.payment", 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "ADD_REFUND")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.payment", 1, String.valueOf(companyId), returnsManagerRole.getRoleId(), "ADD_REFUND");
            }
        }
    }
}

