/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v11_3_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class CommerceOrderUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select commerceOrderId from CommerceOrder where orderStatus = ?");){
            preparedStatement.setInt(1, 2);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long commerceOrderId = resultSet.getLong(1);
                    this.runSQL(StringBundler.concat((Object[])new Object[]{"update CommerceOrder set shippable = ", this._getShippable(this.connection, commerceOrderId), " where commerceOrderId = ", commerceOrderId}));
                }
            }
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CommerceOrder", (String[])new String[]{"shippable BOOLEAN"})};
    }

    private String _getShippable(Connection connection, long commerceOrderId) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select distinct shippable from CommerceOrderItem where commerceOrderId = ?");
        preparedStatement.setLong(1, commerceOrderId);
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                if (!resultSet.getBoolean("shippable")) continue;
                String string = "[$TRUE$]";
                return string;
            }
        }
        return "[$FALSE$]";
    }
}

