/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.starter;

import com.liferay.commerce.starter.CommerceRegionsStarter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceRegionsStarter
implements CommerceRegionsStarter {
    @Reference
    protected CountryLocalService countryLocalService;
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected RegionLocalService regionLocalService;
    @Reference
    protected UserLocalService userLocalService;

    public String getKey() {
        return String.valueOf(this.getCountryIsoCode());
    }

    public void start(long userId) throws Exception {
        User user = this.userLocalService.getUser(userId);
        Country country = this.countryLocalService.fetchCountryByNumber(user.getCompanyId(), String.valueOf(this.getCountryIsoCode()));
        if (country == null) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        this._importCommerceRegions(country, serviceContext);
    }

    protected abstract int getCountryIsoCode();

    protected abstract String getFilePath();

    private JSONArray _getCommerceRegionsJSONArray() throws Exception {
        Class<?> clazz = this.getClass();
        String regionsJSON = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)this.getFilePath(), (boolean)false);
        return this.jsonFactory.createJSONArray(regionsJSON);
    }

    private void _importCommerceRegions(Country country, ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getCommerceRegionsJSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String code = jsonObject.getString("code");
            String name = jsonObject.getString("name");
            double priority = jsonObject.getDouble("priority");
            this.regionLocalService.addRegion(country.getCountryId(), true, name, priority, code, serviceContext);
        }
    }
}

