/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.query.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.util.AccountEntryAllowedTypesUtil;
import com.liferay.commerce.util.CommerceChannelConfigurationUtil;
import com.liferay.commerce.util.CommerceGroupThreadLocal;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrder"}, service={ModelPreFilterContributor.class})
public class CommerceOrderModelPreFilterContributor
implements ModelPreFilterContributor {
    private static final int _MAX_CLAUSES_COUNT = 1024;
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelPreFilterContributor.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference(target="(resource.name=com.liferay.commerce.order)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByCommerceAccountIds(booleanFilter, searchContext);
        this._filterByGroupIds(booleanFilter, searchContext);
        this._filterByOrderStatuses(booleanFilter, searchContext);
        this._filterByUserId(booleanFilter);
    }

    private void _filterByCommerceAccountIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] commerceAccountIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountIds"), null);
        if (commerceAccountIds == null) {
            return;
        }
        BooleanFilter commerceAccountIdBooleanFilter = new BooleanFilter();
        BooleanFilter nestedBooleanFilter = new BooleanFilter();
        for (int i = 0; i < commerceAccountIds.length; ++i) {
            nestedBooleanFilter.add((Filter)new TermFilter("commerceAccountId", String.valueOf(commerceAccountIds[i])), BooleanClauseOccur.SHOULD);
            if ((i + 1) % 1024 != 0) continue;
            commerceAccountIdBooleanFilter.add((Filter)nestedBooleanFilter, BooleanClauseOccur.SHOULD);
            nestedBooleanFilter = new BooleanFilter();
        }
        if (nestedBooleanFilter.hasClauses()) {
            commerceAccountIdBooleanFilter.add((Filter)nestedBooleanFilter, BooleanClauseOccur.SHOULD);
        }
        commerceAccountIdBooleanFilter.add((Filter)new MissingFilter("commerceAccountId"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)commerceAccountIdBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByGroupIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        if (ArrayUtil.isEmpty((long[])searchContext.getGroupIds())) {
            booleanFilter.addTerm("groupId", "-1", BooleanClauseOccur.MUST);
        }
    }

    private void _filterByOrderStatuses(BooleanFilter booleanFilter, SearchContext searchContext) {
        int[] orderStatuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("orderStatuses"), null);
        if (orderStatuses == null) {
            return;
        }
        BooleanFilter orderStatusesBooleanFilter = new BooleanFilter();
        int[] nArray = orderStatuses;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long orderStatus = nArray[i];
            orderStatusesBooleanFilter.add((Filter)new TermFilter("orderStatus", String.valueOf(orderStatus)), BooleanClauseOccur.SHOULD);
        }
        orderStatusesBooleanFilter.add((Filter)new MissingFilter("orderStatus"), BooleanClauseOccur.SHOULD);
        if (GetterUtil.getBoolean((Object)searchContext.getAttribute("negateOrderStatuses"))) {
            booleanFilter.add((Filter)orderStatusesBooleanFilter, BooleanClauseOccur.MUST_NOT);
        } else {
            booleanFilter.add((Filter)orderStatusesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterBySupplierAccountEntryType(AccountEntry accountEntry, BooleanFilter booleanFilter) {
        for (CommerceChannel commerceChannel : this._commerceChannelLocalService.getCommerceChannelsByAccountEntryId(accountEntry.getAccountEntryId())) {
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(commerceChannel.getGroupId())), BooleanClauseOccur.SHOULD);
        }
    }

    private void _filterByUserId(BooleanFilter booleanFilter) {
        block9: {
            try {
                Group group = CommerceGroupThreadLocal.get();
                if (group == null) {
                    return;
                }
                CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelByGroupClassPK(group.getGroupId());
                if (commerceChannel == null) {
                    commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(group.getGroupId());
                }
                if (commerceChannel == null || !"user".equals(CommerceChannelConfigurationUtil.getOpenCommerceOrderVisibilityScope((long)commerceChannel.getGroupId())) && !"user".equals(CommerceChannelConfigurationUtil.getPlacedCommerceOrderVisibilityScope((long)commerceChannel.getGroupId()))) {
                    return;
                }
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                User user = this._userLocalService.fetchUser(permissionChecker.getUserId());
                if (user == null) {
                    return;
                }
                BooleanFilter userVisibilityScopeBooleanFilter = new BooleanFilter();
                CommerceAccountGroupServiceConfiguration commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.account"));
                for (AccountEntry accountEntry : this._accountEntryLocalService.getUserAccountEntries(user.getUserId(), Long.valueOf(0L), "", AccountEntryAllowedTypesUtil.getAllowedTypes((int)commerceAccountGroupServiceConfiguration.commerceSiteType()), -1, -1)) {
                    if ("supplier".equals(accountEntry.getType())) {
                        this._filterBySupplierAccountEntryType(accountEntry, userVisibilityScopeBooleanFilter);
                        continue;
                    }
                    if (this._hasPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDERS", "VIEW_ORGANIZATION_COMMERCE_ORDERS")) {
                        userVisibilityScopeBooleanFilter.add((Filter)new TermFilter("commerceAccountId", String.valueOf(accountEntry.getAccountEntryId())), BooleanClauseOccur.SHOULD);
                        continue;
                    }
                    userVisibilityScopeBooleanFilter.add((Filter)this._getUserVisibilityScopeBooleanFilter(accountEntry, commerceChannel, user), BooleanClauseOccur.SHOULD);
                }
                booleanFilter.add((Filter)userVisibilityScopeBooleanFilter, BooleanClauseOccur.MUST);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Throwable)portalException);
            }
        }
    }

    private BooleanFilter _getUserVisibilityScopeBooleanFilter(AccountEntry accountEntry, CommerceChannel commerceChannel, User user) {
        BooleanFilter booleanFilter = new BooleanFilter();
        if ("user".equals(CommerceChannelConfigurationUtil.getOpenCommerceOrderVisibilityScope((long)commerceChannel.getGroupId())) && !"user".equals(CommerceChannelConfigurationUtil.getPlacedCommerceOrderVisibilityScope((long)commerceChannel.getGroupId()))) {
            BooleanFilter openCommerceOrderBooleanFilter = new BooleanFilter();
            openCommerceOrderBooleanFilter.add((Filter)new TermFilter("commerceAccountId", String.valueOf(accountEntry.getAccountEntryId())), BooleanClauseOccur.MUST);
            openCommerceOrderBooleanFilter.add((Filter)new TermFilter("userId", String.valueOf(user.getUserId())), BooleanClauseOccur.MUST);
            openCommerceOrderBooleanFilter.add((Filter)new TermFilter("orderStatus", String.valueOf(2)), BooleanClauseOccur.MUST);
            booleanFilter.add((Filter)openCommerceOrderBooleanFilter, BooleanClauseOccur.SHOULD);
            BooleanFilter placedCommerceOrderBooleanFilter = new BooleanFilter();
            placedCommerceOrderBooleanFilter.add((Filter)new TermFilter("orderStatus", String.valueOf(2)), BooleanClauseOccur.MUST_NOT);
            booleanFilter.add((Filter)placedCommerceOrderBooleanFilter, BooleanClauseOccur.SHOULD);
            return booleanFilter;
        }
        if (!"user".equals(CommerceChannelConfigurationUtil.getOpenCommerceOrderVisibilityScope((long)commerceChannel.getGroupId())) && "user".equals(CommerceChannelConfigurationUtil.getPlacedCommerceOrderVisibilityScope((long)commerceChannel.getGroupId()))) {
            BooleanFilter placedCommerceOrderBooleanFilter = new BooleanFilter();
            placedCommerceOrderBooleanFilter.add((Filter)new TermFilter("commerceAccountId", String.valueOf(accountEntry.getAccountEntryId())), BooleanClauseOccur.MUST);
            placedCommerceOrderBooleanFilter.add((Filter)new TermFilter("userId", String.valueOf(user.getUserId())), BooleanClauseOccur.MUST);
            placedCommerceOrderBooleanFilter.add((Filter)new TermFilter("orderStatus", String.valueOf(2)), BooleanClauseOccur.MUST_NOT);
            booleanFilter.add((Filter)placedCommerceOrderBooleanFilter, BooleanClauseOccur.SHOULD);
            booleanFilter.add((Filter)new TermFilter("orderStatus", String.valueOf(2)), BooleanClauseOccur.SHOULD);
            return booleanFilter;
        }
        booleanFilter.add((Filter)new TermFilter("commerceAccountId", String.valueOf(accountEntry.getAccountEntryId())), BooleanClauseOccur.MUST);
        booleanFilter.add((Filter)new TermFilter("userId", String.valueOf(user.getUserId())), BooleanClauseOccur.MUST);
        return booleanFilter;
    }

    private boolean _hasPermission(PermissionChecker permissionChecker, long groupId, String ... actionIds) {
        for (String actionId : actionIds) {
            if (!this._portletResourcePermission.contains(permissionChecker, groupId, actionId)) continue;
            return true;
        }
        return false;
    }
}

