/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.internal.util.AccountEntryUtil;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelService;
import com.liferay.commerce.util.CommerceContextThreadLocal;
import com.liferay.commerce.util.CommerceGroupThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFilterContributor;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SearchPermissionFilterContributor.class})
public class AccountEntrySearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntrySearchPermissionFilterContributor.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private CommerceChannelAccountEntryRelService _commerceChannelAccountEntryRelService;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(AccountEntry.class.getName())) {
            return;
        }
        try {
            this._addCommerceChannelIdsFilter(booleanFilter, userId);
            if (this._accountEntryModelResourcePermission.contains(permissionChecker, 0L, "MANAGE_AVAILABLE_ACCOUNTS_VIA_USER_CHANNEL_REL")) {
                ArrayList commerceChannelAccountEntryRels = new ArrayList();
                commerceChannelAccountEntryRels.addAll(this._commerceChannelAccountEntryRelService.getCommerceChannelAccountEntryRels(User.class.getName(), userId, 0L, 7));
                long commerceChannelId = AccountEntryUtil.getCommerceChannelId(CommerceContextThreadLocal.get(), CommerceGroupThreadLocal.get());
                if (commerceChannelId > 0L) {
                    commerceChannelAccountEntryRels.addAll(this._commerceChannelAccountEntryRelService.getCommerceChannelAccountEntryRels(User.class.getName(), userId, commerceChannelId, 7));
                }
                TermsFilter termsFilter = new TermsFilter("entryClassPK");
                for (CommerceChannelAccountEntryRel commerceChannelAccountEntryRel : commerceChannelAccountEntryRels) {
                    termsFilter.addValue(String.valueOf(commerceChannelAccountEntryRel.getAccountEntryId()));
                }
                if (!termsFilter.isEmpty()) {
                    booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
                }
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _addCommerceChannelIdsFilter(BooleanFilter booleanFilter, long userId) throws PortalException {
        long commerceChannelId = AccountEntryUtil.getCommerceChannelId(CommerceContextThreadLocal.get(), CommerceGroupThreadLocal.get());
        int count = this._commerceChannelAccountEntryRelService.getCommerceChannelAccountEntryRelsCount(commerceChannelId, null, 9);
        if (commerceChannelId > 0L && count > 0) {
            TermsFilter accountUserIdsTermsFilter = new TermsFilter("accountUserIds");
            accountUserIdsTermsFilter.addValue(String.valueOf(userId));
            booleanFilter.add((Filter)accountUserIdsTermsFilter, BooleanClauseOccur.MUST);
            TermsFilter termsFilter = new TermsFilter("commerceChannelIds");
            termsFilter.addValues(ArrayUtil.toStringArray((long[])new long[]{commerceChannelId}));
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }
}

