/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.term.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOption;
import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.commerce.payment.exception.NoSuchPaymentMethodGroupRelException;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ListTypeService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.definition.term.contributor.key=BodyAndSubjectTerms", "commerce.notification.type.key=order-awaiting-shipment", "commerce.notification.type.key=order-completed", "commerce.notification.type.key=order-partially-shipped", "commerce.notification.type.key=order-placed", "commerce.notification.type.key=order-processing", "commerce.notification.type.key=order-shipped"}, service={CommerceDefinitionTermContributor.class})
public class CommerceOrderCommerceDefinitionTermContributor
implements CommerceDefinitionTermContributor {
    public static final String KEY = "BodyAndSubjectTerms";
    private static final String _DELIVERY_TERMS_DESCRIPTION = "[%DELIVERY_TERMS_DESCRIPTION%]";
    private static final String _ORDER_BILLING_ADDRESS = "[%ORDER_BILLING_ADDRESS%]";
    private static final String _ORDER_CREATOR = "[%ORDER_CREATOR%]";
    private static final String _ORDER_CREATOR_USER_FIRST_NAME = "[%ORDER_CREATOR_USER_FIRST_NAME%]";
    private static final String _ORDER_CREATOR_USER_LAST_NAME = "[%ORDER_CREATOR_USER_LAST_NAME%]";
    private static final String _ORDER_CREATOR_USER_TITLE = "[%ORDER_CREATOR_USER_TITLE%]";
    private static final String _ORDER_CURRENCY_CODE = "[%ORDER_CURRENCY_CODE%]";
    private static final String _ORDER_CURRENCY_SYMBOL = "[%ORDER_CURRENCY_SYMBOL%]";
    private static final String _ORDER_DATE = "[%ORDER_DATE%]";
    private static final String _ORDER_EXTERNAL_REFERENCE_CODE = "[%ORDER_EXTERNAL_REFERENCE_CODE%]";
    private static final String _ORDER_ID = "[%ORDER_ID%]";
    private static final String _ORDER_ITEMS = "[%ORDER_ITEMS%]";
    private static final String _ORDER_PAYMENT_METHOD = "[%ORDER_PAYMENT_METHOD%]";
    private static final String _ORDER_SHIPPING_ADDRESS = "[%ORDER_SHIPPING_ADDRESS%]";
    private static final String _ORDER_SHIPPING_OPTION = "[%ORDER_SHIPPING_OPTION%]";
    private static final String _ORDER_SHIPPING_TOTAL = "[%ORDER_SHIPPING_TOTAL%]";
    private static final String _ORDER_SHIPPING_WITH_TAX_TOTAL = "[%ORDER_SHIPPING_WITH_TAX_TOTAL%]";
    private static final String _ORDER_TAX_TOTAL = "[%ORDER_TAX_TOTAL%]";
    private static final String _ORDER_TOTAL = "[%ORDER_TOTAL%]";
    private static final String _ORDER_URL = "[%ORDER_URL%]";
    private static final String _ORDER_WITH_TAX_TOTAL = "[%ORDER_WITH_TAX_TOTAL%]";
    private static final String _PAYMENT_TERMS_DESCRIPTION = "[%PAYMENT_TERMS_DESCRIPTION%]";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderCommerceDefinitionTermContributor.class);
    private static final Map<String, String> _languageKeys = HashMapBuilder.put((Object)"[%DELIVERY_TERMS_DESCRIPTION%]", (Object)"delivery_terms_description").put((Object)"[%ORDER_BILLING_ADDRESS%]", (Object)"order_billing_address").put((Object)"[%ORDER_CREATOR%]", (Object)"order_creator").put((Object)"[%ORDER_CREATOR_USER_FIRST_NAME%]", (Object)"order_creator_user_first_name").put((Object)"[%ORDER_CREATOR_USER_LAST_NAME%]", (Object)"order_creator_user_last_name").put((Object)"[%ORDER_CREATOR_USER_TITLE%]", (Object)"order_creator_user_title").put((Object)"[%ORDER_CURRENCY_CODE%]", (Object)"order_currency_code").put((Object)"[%ORDER_CURRENCY_SYMBOL%]", (Object)"order_currency_symbol").put((Object)"[%ORDER_DATE%]", (Object)"order_date").put((Object)"[%ORDER_EXTERNAL_REFERENCE_CODE%]", (Object)"order_external_reference_code").put((Object)"[%ORDER_ID%]", (Object)"order_id").put((Object)"[%ORDER_ITEMS%]", (Object)"order_items").put((Object)"[%ORDER_PAYMENT_METHOD%]", (Object)"order_payment_method").put((Object)"[%ORDER_SHIPPING_ADDRESS%]", (Object)"order_shipping_address").put((Object)"[%ORDER_SHIPPING_OPTION%]", (Object)"order_shipping_option").put((Object)"[%ORDER_SHIPPING_TOTAL%]", (Object)"order_shipping_total").put((Object)"[%ORDER_SHIPPING_WITH_TAX_TOTAL%]", (Object)"order_shipping_with_tax_total").put((Object)"[%ORDER_TAX_TOTAL%]", (Object)"order_tax_total").put((Object)"[%ORDER_TOTAL%]", (Object)"order_total").put((Object)"[%ORDER_URL%]", (Object)"order_url").put((Object)"[%ORDER_WITH_TAX_TOTAL%]", (Object)"order_with_tax_total").put((Object)"[%PAYMENT_TERMS_DESCRIPTION%]", (Object)"payment_terms_description").build();
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private ListTypeService _listTypeService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        if (!(object instanceof CommerceOrder)) {
            return term;
        }
        CommerceOrder commerceOrder = (CommerceOrder)object;
        if (term.equals(_DELIVERY_TERMS_DESCRIPTION)) {
            return commerceOrder.getDeliveryCommerceTermEntryDescription();
        }
        if (term.equals(_ORDER_BILLING_ADDRESS)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing billing address term");
            }
            return this._formatAddressTerm(commerceOrder.getBillingAddress(), locale);
        }
        if (term.equals(_ORDER_CREATOR)) {
            return this._getOrderCreatorTerm(commerceOrder);
        }
        if (term.equals(_ORDER_CREATOR_USER_FIRST_NAME)) {
            User user = this._userLocalService.getUser(commerceOrder.getUserId());
            return user.getFirstName();
        }
        if (term.equals(_ORDER_CREATOR_USER_LAST_NAME)) {
            User user = this._userLocalService.getUser(commerceOrder.getUserId());
            return user.getLastName();
        }
        if (term.equals(_ORDER_CREATOR_USER_TITLE)) {
            return this._getOrderCreatorUserTitleTerm(commerceOrder, locale);
        }
        if (term.equals(_ORDER_CURRENCY_CODE)) {
            CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
            return commerceCurrency.getCode();
        }
        if (term.equals(_ORDER_CURRENCY_SYMBOL)) {
            CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
            return commerceCurrency.getSymbol();
        }
        if (term.equals(_ORDER_DATE)) {
            return this._getOrderDateTerm(commerceOrder, locale);
        }
        if (term.equals(_ORDER_EXTERNAL_REFERENCE_CODE)) {
            return commerceOrder.getExternalReferenceCode();
        }
        if (term.equals(_ORDER_ID)) {
            return String.valueOf(commerceOrder.getCommerceOrderId());
        }
        if (term.equals(_ORDER_ITEMS)) {
            return this._getOrderItemsTerm(commerceOrder, locale);
        }
        if (term.equals(_ORDER_PAYMENT_METHOD)) {
            return this._getOrderPaymentMethodTerm(commerceOrder, locale);
        }
        if (term.equals(_ORDER_SHIPPING_ADDRESS)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing shipping address term");
            }
            return this._formatAddressTerm(commerceOrder.getShippingAddress(), locale);
        }
        if (term.equals(_ORDER_SHIPPING_OPTION)) {
            return this._getOrderShippinhOptionTerm(commerceOrder, locale);
        }
        if (term.equals(_ORDER_SHIPPING_TOTAL)) {
            return this._formatAmount(commerceOrder, commerceOrder.getShippingAmount());
        }
        if (term.equals(_ORDER_SHIPPING_WITH_TAX_TOTAL)) {
            return this._formatAmount(commerceOrder, commerceOrder.getShippingWithTaxAmount());
        }
        if (term.equals(_ORDER_TAX_TOTAL)) {
            return this._formatAmount(commerceOrder, commerceOrder.getTaxAmount());
        }
        if (term.equals(_ORDER_TOTAL)) {
            return this._formatAmount(commerceOrder, commerceOrder.getTotal());
        }
        if (term.equals(_ORDER_WITH_TAX_TOTAL)) {
            return this._formatAmount(commerceOrder, commerceOrder.getTotalWithTaxAmount());
        }
        if (term.equals(_ORDER_URL)) {
            return this._getOrderUrlTerm(commerceOrder);
        }
        if (term.equals(_PAYMENT_TERMS_DESCRIPTION)) {
            return commerceOrder.getPaymentCommerceTermEntryDescription();
        }
        return term;
    }

    public String getLabel(String term, Locale locale) {
        return this._language.get(locale, _languageKeys.get(term));
    }

    public List<String> getTerms() {
        return new ArrayList<String>(_languageKeys.keySet());
    }

    private String _formatAddressTerm(CommerceAddress commerceAddress, Locale locale) {
        StringBundler addressSB;
        block9: {
            if (commerceAddress == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Commerce address is null");
                }
                return "";
            }
            addressSB = new StringBundler(commerceAddress.getName());
            addressSB.append("<br/>");
            addressSB.append(commerceAddress.getStreet1());
            addressSB.append("<br/>");
            if (!Validator.isBlank((String)commerceAddress.getStreet2())) {
                addressSB.append(commerceAddress.getStreet2());
                addressSB.append("<br/>");
            }
            if (!Validator.isBlank((String)commerceAddress.getStreet3())) {
                addressSB.append(commerceAddress.getStreet3());
                addressSB.append("<br/>");
            }
            addressSB.append(commerceAddress.getCity());
            addressSB.append(", ");
            addressSB.append(commerceAddress.getZip());
            addressSB.append("<br/>");
            try {
                Country country;
                Region region = commerceAddress.getRegion();
                if (region != null) {
                    addressSB.append(region.getName());
                    addressSB.append(", ");
                }
                if ((country = commerceAddress.getCountry()) != null) {
                    addressSB.append(country.getTitle(locale));
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)"It was not possible to get either the country or region for this commerce address", (Throwable)portalException);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding address term to the notification: " + addressSB.toString()));
        }
        return addressSB.toString();
    }

    private String _formatAmount(CommerceOrder commerceOrder, BigDecimal amount) throws PortalException {
        if (amount != null) {
            CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
            return String.valueOf(commerceCurrency.round(amount));
        }
        return "";
    }

    private String _getOrderCreatorTerm(CommerceOrder commerceOrder) throws PortalException {
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        if (accountEntry.isPersonalAccount()) {
            User user = this._userLocalService.getUser(accountEntry.getUserId());
            return user.getFullName(true, true);
        }
        return accountEntry.getName();
    }

    private String _getOrderCreatorUserTitleTerm(CommerceOrder commerceOrder, Locale locale) throws PortalException {
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        Contact contact = user.getContact();
        long prefixListTypeId = contact.getPrefixListTypeId();
        if (prefixListTypeId > 0L) {
            ListType listType = this._listTypeService.getListType(prefixListTypeId);
            return this._language.get(locale, listType.getName());
        }
        return "";
    }

    private String _getOrderDateTerm(CommerceOrder commerceOrder, Locale locale) throws PortalException {
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        Format commerceOrderDateFormat = FastDateFormatFactoryUtil.getDate((int)2, (Locale)locale, (TimeZone)user.getTimeZone());
        Format commerceOrderTimeFormat = FastDateFormatFactoryUtil.getTime((int)2, (Locale)locale, (TimeZone)user.getTimeZone());
        Date orderDate = commerceOrder.getOrderDate();
        return commerceOrderDateFormat.format(orderDate) + " " + commerceOrderTimeFormat.format(orderDate);
    }

    private String _getOrderItemsTerm(CommerceOrder commerceOrder, Locale locale) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Processing order items term");
        }
        if (commerceOrder == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Trying to get the item list for an order without an order object");
            }
            return "";
        }
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        if (ListUtil.isEmpty((List)commerceOrderItems)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"This order has no linked order items to be included in the mail notification");
            }
            return "";
        }
        StringBundler orderItemsTableSB = new StringBundler("<table style=\"border: 1px solid black;\">");
        orderItemsTableSB.append("<tr><th style=\"border: 1px solid black;\">");
        orderItemsTableSB.append(this._language.get(locale, "product-name"));
        orderItemsTableSB.append("</th>");
        orderItemsTableSB.append("<th style=\"border: 1px solid black;\">");
        orderItemsTableSB.append(this._language.get(locale, "sku"));
        orderItemsTableSB.append("</th>");
        orderItemsTableSB.append("<th style=\"border: 1px solid black;\">");
        orderItemsTableSB.append(this._language.get(locale, "quantity"));
        orderItemsTableSB.append("</th></tr>");
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            orderItemsTableSB.append("<tr><td style=\"border: 1px solid black;\">");
            orderItemsTableSB.append(commerceOrderItem.getName(locale));
            orderItemsTableSB.append("</td><td style=\"border: 1px solid black;\">");
            orderItemsTableSB.append(commerceOrderItem.getSku());
            orderItemsTableSB.append("</td><td style=\"border: 1px solid black;\">");
            orderItemsTableSB.append((Object)commerceOrderItem.getQuantity());
            orderItemsTableSB.append("</td></tr>");
        }
        orderItemsTableSB.append("</table>");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Order items table built successfully: " + orderItemsTableSB.toString()));
        }
        return orderItemsTableSB.toString();
    }

    private String _getOrderPaymentMethodTerm(CommerceOrder commerceOrder, Locale locale) throws NoSuchPaymentMethodGroupRelException {
        if (!Validator.isBlank((String)commerceOrder.getCommercePaymentMethodKey())) {
            CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commerceOrder.getCommercePaymentMethodKey());
            return commercePaymentMethodGroupRel.getName(locale);
        }
        return "";
    }

    private String _getOrderShippinhOptionTerm(CommerceOrder commerceOrder, Locale locale) throws PortalException {
        CommerceShippingFixedOption commerceShippingFixedOption = this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(commerceOrder.getCompanyId(), commerceOrder.getShippingOptionName());
        if (commerceShippingFixedOption != null) {
            return commerceShippingFixedOption.getName(locale);
        }
        CommerceShippingMethod commerceShippingMethod = commerceOrder.getCommerceShippingMethod();
        if (commerceShippingMethod == null) {
            return "";
        }
        CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(commerceShippingMethod.getEngineKey());
        if (commerceShippingEngine == null) {
            return "";
        }
        for (CommerceShippingOption commerceShippingOption : commerceShippingEngine.getCommerceShippingOptions(null, commerceOrder, locale)) {
            if (!Objects.equals(commerceShippingOption.getKey(), commerceOrder.getShippingOptionName())) continue;
            return commerceShippingOption.getName();
        }
        return "";
    }

    private String _getOrderUrlTerm(CommerceOrder commerceOrder) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        String portalURL = "";
        if (StringUtil.equals((String)commerceChannel.getType(), (String)"site")) {
            Company company = this._companyLocalService.getCompany(commerceOrder.getCompanyId());
            StringBuffer sb = new StringBuffer();
            sb.append(company.getPortalURL(commerceOrder.getGroupId()));
            Layout layout = null;
            layout = commerceOrder.isOpen() ? this._layoutLocalService.getLayout(this._portal.getPlidFromPortletId(commerceChannel.getSiteGroupId(), "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet")) : this._layoutLocalService.getLayout(this._portal.getPlidFromPortletId(commerceChannel.getSiteGroupId(), "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet"));
            if (layout.isPublicLayout()) {
                sb.append(this._portal.getPathFriendlyURLPublic());
            } else {
                sb.append(this._portal.getPathFriendlyURLPrivateGroup());
            }
            Group group = layout.getGroup();
            sb.append(group.getFriendlyURL());
            sb.append(layout.getFriendlyURL());
            sb.append("/-/");
            sb.append("placed-order");
            sb.append("/");
            sb.append(commerceOrder.getCommerceOrderId());
            portalURL = sb.toString();
        }
        return portalURL;
    }
}

