/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryService;
import com.liferay.asset.display.page.util.AssetDisplayPageUtil;
import com.liferay.commerce.configuration.CommerceOrderCheckoutConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.helper.CommerceAccountHelper;
import com.liferay.commerce.internal.order.VersionCommerceOrderValidatorImpl;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.commerce.util.CommerceCheckoutStep;
import com.liferay.commerce.util.CommerceCheckoutStepRegistry;
import com.liferay.commerce.util.CommerceOrderInfoItemUtil;
import com.liferay.friendly.url.provider.FriendlyURLSeparatorProvider;
import com.liferay.info.item.InfoItemReference;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.portlet.ActionRequest;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.portlet.WindowStateException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderHttpHelper.class})
public class CommerceOrderHttpHelperImpl
implements CommerceOrderHttpHelper {
    @Reference
    protected LayoutDisplayPageProviderRegistry layoutDisplayPageProviderRegistry;
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderHttpHelperImpl.class);
    private static final ThreadLocal<CommerceOrder> _commerceOrder = new CentralizedThreadLocal(CommerceOrderHttpHelperImpl.class.getName() + "._commerceOrder");
    private static final Snapshot<FriendlyURLSeparatorProvider> _friendlyURLSeparatorProviderSnapshot = new Snapshot(CommerceOrderHttpHelperImpl.class, FriendlyURLSeparatorProvider.class);
    private static final ThreadLocal<Boolean> _initialized = new CentralizedThreadLocal(CommerceOrderHttpHelperImpl.class.getName() + "._initialized", () -> false);
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCheckoutStepRegistry _commerceCheckoutStepRegistry;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceShipmentLocalService _commerceShipmentLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;

    public CommerceOrder addCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        AccountEntry accountEntry;
        CommerceContext commerceContext = this._getCommerceContext(httpServletRequest);
        CommerceOrder commerceOrder = null;
        String commerceCurrencyCode = null;
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (commerceCurrency != null) {
            commerceCurrencyCode = commerceCurrency.getCode();
        }
        if ((accountEntry = commerceContext.getAccountEntry()) != null) {
            commerceOrder = this._commerceOrderService.addCommerceOrder(commerceContext.getCommerceChannelGroupId(), accountEntry.getAccountEntryId(), commerceCurrencyCode, 0L);
        }
        if (accountEntry == null) {
            throw new CommerceOrderValidatorException(Collections.singletonList(new CommerceOrderValidatorResult(false, this._getLocalizedMessage(this._portal.getLocale(httpServletRequest), "please-select-a-valid-account"))));
        }
        this.setCurrentCommerceOrder(httpServletRequest, commerceOrder);
        return commerceOrder;
    }

    public void deleteCommerceOrder(ActionRequest actionRequest, long commerceOrderId) throws PortalException {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        httpServletRequest.removeAttribute("COMMERCE_ORDER");
        HttpSession httpSession = httpServletRequest.getSession();
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        httpSession.removeAttribute(CommerceOrder.class.getName() + "#" + commerceOrder.getGroupId());
        this._commerceOrderService.deleteCommerceOrder(commerceOrderId);
    }

    public CommerceOrder fetchCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    public String getCommerceCartBaseURL(HttpServletRequest httpServletRequest) throws PortalException {
        if (this.hasCommerceOrderPortlet(httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet")) {
            long plid = PortalUtil.getPlidFromPortletId((long)PortalUtil.getScopeGroupId((HttpServletRequest)httpServletRequest), (String)"com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
            return PortletURLBuilder.create((PortletURL)this._portletURLFactory.create(httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet", plid, "RENDER_PHASE")).setMVCRenderCommandName("/commerce_open_order_content/edit_commerce_order").setBackURL(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL")).buildString();
        }
        return HtmlUtil.escape((String)CommerceOrderInfoItemUtil.getCommerceOrderFriendlyURL((FriendlyURLSeparatorProvider)((FriendlyURLSeparatorProvider)_friendlyURLSeparatorProviderSnapshot.get()), (HttpServletRequest)httpServletRequest));
    }

    public String getCommerceCartPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        return this.getCommerceCartPortletURL(httpServletRequest, commerceOrder);
    }

    public String getCommerceCartPortletURL(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        return this.getCommerceCartPortletURL(groupId, httpServletRequest, commerceOrder);
    }

    public String getCommerceCartPortletURL(long groupId, HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider;
        if (commerceOrder != null && FeatureFlagManagerUtil.isEnabled((String)"LPD-20379") && (layoutDisplayPageObjectProvider = this._getLayoutDisplayPageObjectProvider(commerceOrder)) != null && AssetDisplayPageUtil.hasAssetDisplayPage((long)groupId, (long)layoutDisplayPageObjectProvider.getClassNameId(), (long)layoutDisplayPageObjectProvider.getClassPK(), (long)layoutDisplayPageObjectProvider.getClassTypeId())) {
            String commerceOrderFriendlyURL = CommerceOrderInfoItemUtil.getCommerceOrderFriendlyURL((FriendlyURLSeparatorProvider)((FriendlyURLSeparatorProvider)_friendlyURLSeparatorProviderSnapshot.get()), (HttpServletRequest)httpServletRequest);
            return commerceOrderFriendlyURL + commerceOrder.getCommerceOrderId();
        }
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
        if (plid > 0L && commerceOrder != null && !commerceOrder.isOpen()) {
            PortletURL portletURL = this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "/commerce_order_content/view_commerce_order_details");
                portletURL.setParameter("backURL", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL"));
                portletURL.setParameter("commerceOrderUuid", String.valueOf(commerceOrder.getUuid()));
                portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrder.getCommerceOrderId()));
            }
            return portletURL.toString();
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
        if (plid > 0L && commerceOrder != null && commerceOrder.isOpen()) {
            PortletURL portletURL = this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "/commerce_open_order_content/edit_commerce_order");
                portletURL.setParameter("backURL", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL"));
                portletURL.setParameter("commerceOrderUuid", String.valueOf(commerceOrder.getUuid()));
            }
            return portletURL.toString();
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        if (plid > 0L) {
            return PortletURLBuilder.create((PortletURL)this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet")).setBackURL(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL")).buildString();
        }
        return "";
    }

    public PortletURL getCommerceCheckoutPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        LiferayPortletURL portletURL = (LiferayPortletURL)this._getPortletURL(httpServletRequest, "com_liferay_commerce_checkout_web_internal_portlet_CommerceCheckoutPortlet");
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder == null) {
            return portletURL;
        }
        httpServletRequest.setAttribute("COMMERCE_ORDER", (Object)commerceOrder);
        if (commerceOrder.isEmpty()) {
            return portletURL;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String checkoutStepName = "";
        try {
            List commerceCheckoutSteps = this._commerceCheckoutStepRegistry.getCommerceCheckoutSteps(httpServletRequest, themeDisplay.getResponse(), true);
            if (commerceCheckoutSteps != null && !commerceCheckoutSteps.isEmpty()) {
                CommerceCheckoutStep commerceCheckoutStep = (CommerceCheckoutStep)commerceCheckoutSteps.get(0);
                checkoutStepName = commerceCheckoutStep.getName();
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new PortalException((Throwable)exception);
        }
        portletURL.setParameter("checkoutStepName", checkoutStepName);
        portletURL.setParameter("commerceOrderUuid", commerceOrder.getUuid());
        try {
            portletURL.setWindowState(LiferayWindowState.NORMAL);
        }
        catch (WindowStateException windowStateException) {
            _log.error((Throwable)windowStateException);
            throw new PortalException((Throwable)windowStateException);
        }
        if (commerceOrder.getCommerceAccountId() == -1L) {
            LiferayPortletURL checkoutPortletURL = portletURL;
            Layout currentLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            String friendlyURL = "/authentication";
            Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(this._portal.getScopeGroupId(httpServletRequest), false, friendlyURL);
            if (!friendlyURL.equals(currentLayout.getFriendlyURL()) && layout != null) {
                portletURL = this._portletURLFactory.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", layout, "RENDER_PHASE");
                CommerceContext commerceContext = this._getCommerceContext(httpServletRequest);
                int commerceSiteType = commerceContext.getCommerceSiteType();
                if (commerceSiteType == 1) {
                    Group group = themeDisplay.getSiteGroup();
                    portletURL.setParameter("redirect", group.getDisplayURL(themeDisplay));
                } else {
                    portletURL.setParameter("redirect", checkoutPortletURL.toString());
                }
            } else {
                portletURL.setParameter("continueAsGuest", Boolean.TRUE.toString());
                Cookie cookie = new Cookie("COMMERCE_CONTINUE_AS_GUEST", Boolean.TRUE.toString());
                String domain = CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest);
                if (Validator.isNotNull((String)domain)) {
                    cookie.setDomain(domain);
                }
                cookie.setMaxAge(31536000);
                CookiesManagerUtil.addCookie((int)2, (Cookie)cookie, (HttpServletRequest)httpServletRequest, (HttpServletResponse)themeDisplay.getResponse());
                portletURL.setParameter("redirect", checkoutPortletURL.toString());
            }
        }
        return portletURL;
    }

    public BigDecimal getCommerceOrderItemsQuantity(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder == null) {
            return BigDecimal.ZERO;
        }
        return this._commerceOrderItemService.getCommerceOrderItemsQuantity(commerceOrder.getCommerceOrderId());
    }

    public String getCookieName(long groupId) {
        return CommerceOrder.class.getName() + "#" + groupId;
    }

    public CommerceOrder getCurrentCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        if (GetterUtil.getBoolean((Object)_initialized.get())) {
            return _commerceOrder.get();
        }
        CommerceContext commerceContext = this._getCommerceContext(httpServletRequest);
        if (commerceContext == null) {
            this._setCurrentCommerceOrder(null);
            return null;
        }
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        CommerceOrder commerceOrder = (CommerceOrder)httpSession.getAttribute("COMMERCE_ORDER_ON_ACCOUNT_SELECTION");
        if (commerceOrder != null) {
            this._setCurrentCommerceOrder(commerceOrder);
            return commerceOrder;
        }
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        if (accountEntry == null) {
            this._setCurrentCommerceOrder(null);
            return null;
        }
        commerceOrder = (CommerceOrder)httpServletRequest.getAttribute("COMMERCE_ORDER");
        if (commerceOrder == null) {
            long groupId = commerceContext.getCommerceChannelGroupId();
            String uuid = (String)httpSession.getAttribute(this.getCookieName(groupId));
            commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (commerceOrder != null && !commerceOrder.isOpen()) {
            CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)themeDisplay.getResponse(), (String[])new String[]{CommerceOrder.class.getName() + "#" + commerceOrder.getGroupId()});
            httpSession.removeAttribute(CommerceOrder.class.getName() + "#" + commerceOrder.getGroupId());
            commerceOrder = null;
        }
        if (commerceOrder == null) {
            commerceOrder = this._getCurrentCommerceOrder(commerceContext, httpServletRequest);
        }
        if (commerceOrder != null) {
            if (commerceOrder.isGuestOrder()) {
                commerceOrder = this._checkGuestOrder(commerceContext, commerceOrder, httpServletRequest, themeDisplay);
            } else if (commerceOrder.getCommerceAccountId() != accountEntry.getAccountEntryId()) {
                httpSession.removeAttribute(CommerceOrder.class.getName() + "#" + commerceOrder.getGroupId());
                this._setCurrentCommerceOrder(null);
                return null;
            }
        }
        if (commerceOrder != null && !commerceOrder.isOpen() || commerceOrder != null && !this._commerceOrderModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE")) {
            this._setCurrentCommerceOrder(null);
            return null;
        }
        this._setCurrentCommerceOrder(commerceOrder);
        return commerceOrder;
    }

    public boolean hasCommerceOrderPortlet(HttpServletRequest httpServletRequest, String portletKey) throws PortalException {
        if (portletKey.equals("com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet") || portletKey.equals("com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet") || portletKey.equals("com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet")) {
            long groupId = this._portal.getScopeGroupId(httpServletRequest);
            return this._portal.getPlidFromPortletId(groupId, portletKey) > 0L;
        }
        return false;
    }

    public boolean hasCommerceOrderReturns(HttpServletRequest httpServletRequest) {
        if (!FeatureFlagManagerUtil.isEnabled((long)this._portal.getCompanyId(httpServletRequest), (String)"LPD-10562")) {
            return false;
        }
        CommerceOrder commerceOrder = CommerceOrderInfoItemUtil.getCommerceOrder((CommerceOrderService)this._commerceOrderService, (HttpServletRequest)httpServletRequest);
        if (commerceOrder != null && !commerceOrder.isOpen()) {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode("L_COMMERCE_RETURN", CompanyThreadLocal.getCompanyId().longValue());
            if (objectDefinition == null) {
                return false;
            }
            return ListUtil.exists((List)this._objectEntryLocalService.getObjectEntries(0L, objectDefinition.getObjectDefinitionId(), -1, -1), objectEntry -> {
                Map values = objectEntry.getValues();
                return commerceOrder.getCommerceOrderId() == GetterUtil.getLong(values.get("r_commerceOrderToCommerceReturns_commerceOrderId"));
            });
        }
        return false;
    }

    public boolean hasCommerceOrderShipments(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = CommerceOrderInfoItemUtil.getCommerceOrder((CommerceOrderService)this._commerceOrderService, (HttpServletRequest)httpServletRequest);
        if (commerceOrder == null || commerceOrder.isOpen()) {
            return false;
        }
        List commerceShipment = this._commerceShipmentLocalService.getCommerceShipments(commerceOrder.getCommerceOrderId(), 0, 1);
        return !commerceShipment.isEmpty();
    }

    public boolean isGuestCheckoutEnabled(HttpServletRequest httpServletRequest) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        CommerceOrderCheckoutConfiguration commerceOrderCheckoutConfiguration = (CommerceOrderCheckoutConfiguration)this._configurationProvider.getConfiguration(CommerceOrderCheckoutConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.order"));
        return commerceOrderCheckoutConfiguration.guestCheckoutEnabled();
    }

    public boolean isMultishippingEnabled(HttpServletRequest httpServletRequest) {
        try {
            CommerceOrder commerceOrder = CommerceOrderInfoItemUtil.getCommerceOrder((CommerceOrderService)this._commerceOrderService, (HttpServletRequest)httpServletRequest);
            if (commerceOrder == null || !this._commerceOrderModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceOrder, "MANAGE_COMMERCE_ORDER_MULTISHIPPING")) {
                return false;
            }
            CommerceOrderCheckoutConfiguration commerceOrderCheckoutConfiguration = (CommerceOrderCheckoutConfiguration)this._configurationProvider.getConfiguration(CommerceOrderCheckoutConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest)), "com.liferay.commerce.order"));
            return commerceOrderCheckoutConfiguration.multishippingEnabled();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public void setCurrentCommerceOrder(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntry(commerceOrder.getCommerceAccountId());
        if (accountEntry != null) {
            this._commerceAccountHelper.setCurrentCommerceAccount(httpServletRequest, commerceOrder.getGroupId(), accountEntry.getAccountEntryId());
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        commerceOrder = this._commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest));
        if (themeDisplay != null && !themeDisplay.isSignedIn()) {
            this._setGuestCommerceOrder(commerceOrder, themeDisplay);
            this._setCurrentCommerceOrder(commerceOrder);
            return;
        }
        httpServletRequest.setAttribute("COMMERCE_ORDER", (Object)commerceOrder);
        httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute(this.getCookieName(commerceOrder.getGroupId()), (Object)commerceOrder.getUuid());
        this._setCurrentCommerceOrder(commerceOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommerceOrder _checkGuestOrder(CommerceContext commerceContext, CommerceOrder commerceOrder, HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay) throws PortalException {
        CommerceOrder userCommerceOrder;
        if (commerceOrder == null) {
            return null;
        }
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        if (accountEntry == null) {
            return null;
        }
        User user = this._portal.getUser(httpServletRequest);
        if (user == null || user.isGuestUser()) {
            return commerceOrder;
        }
        boolean mergeGuestOrder = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("MERGE_GUEST_ORDER"), (boolean)true);
        if (!mergeGuestOrder) {
            return commerceOrder;
        }
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        String cookieName = this.getCookieName(commerceOrder.getGroupId());
        CommerceOrder threadLocalCommerceOrder = _commerceOrder.get();
        if (threadLocalCommerceOrder != null && threadLocalCommerceOrder.isGuestOrder()) {
            httpSession.removeAttribute(cookieName);
            this._unsetCurrentCommerceOrder();
        }
        if ((userCommerceOrder = this._commerceOrderService.fetchCommerceOrder(accountEntry.getAccountEntryId(), commerceContext.getCommerceChannelGroupId(), user.getUserId(), 2)) == null) {
            httpSession.removeAttribute(cookieName);
            if (themeDisplay != null) {
                CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)themeDisplay.getResponse(), (String[])new String[]{cookieName});
            }
            commerceOrder = this._commerceOrderLocalService.resetCommerceOrderAddresses(commerceOrder.getCommerceOrderId(), true, true);
            return this._commerceOrderLocalService.updateAccount(commerceOrder.getCommerceOrderId(), user.getUserId(), accountEntry.getAccountEntryId());
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        this._setCurrentCommerceOrder(userCommerceOrder);
        try {
            httpSession.setAttribute(cookieName, (Object)userCommerceOrder.getUuid());
            this._commerceOrderLocalService.mergeGuestCommerceOrder(user.getUserId(), commerceOrder.getCommerceOrderId(), userCommerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest), serviceContext);
        }
        finally {
            this._unsetCurrentCommerceOrder();
        }
        httpSession.removeAttribute(cookieName);
        return userCommerceOrder;
    }

    private String _fetchCommerceOrderUuid(CommerceChannel commerceChannel, HttpServletRequest httpServletRequest) {
        String cookieName;
        if (commerceChannel == null) {
            return null;
        }
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        String commerceOrderUuid = (String)httpSession.getAttribute(cookieName = this.getCookieName(commerceChannel.getGroupId()));
        if (Validator.isNull((String)commerceOrderUuid)) {
            commerceOrderUuid = CookiesManagerUtil.getCookieValue((String)cookieName, (HttpServletRequest)httpServletRequest, (boolean)true);
        }
        return commerceOrderUuid;
    }

    private CommerceContext _getCommerceContext(HttpServletRequest httpServletRequest) {
        return (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
    }

    private CommerceOrder _getCurrentCommerceOrder(CommerceContext commerceContext, HttpServletRequest httpServletRequest) throws PortalException {
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        String commerceOrderUuid = this._fetchCommerceOrderUuid(commerceChannel, httpServletRequest);
        CommerceOrder commerceOrder = _commerceOrder.get();
        if (commerceOrder != null) {
            CommerceOrder persistedCommerceOrder = this._commerceOrderLocalService.fetchCommerceOrder(commerceOrder.getCommerceOrderId());
            if (persistedCommerceOrder != null) {
                commerceOrder = persistedCommerceOrder;
                this._setCurrentCommerceOrder(commerceOrder);
            }
            if (accountEntry == null || accountEntry.getAccountEntryId() == -1L || Validator.isNotNull((String)commerceOrderUuid) && commerceOrderUuid.equals(commerceOrder.getUuid()) && accountEntry.getAccountEntryId() == commerceOrder.getCommerceAccountId()) {
                return commerceOrder;
            }
        }
        if (accountEntry == null || commerceChannel == null) {
            return null;
        }
        if (accountEntry.getAccountEntryId() != -1L) {
            commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannel.getGroupId());
            if (commerceOrder == null || !commerceOrder.isGuestOrder() && accountEntry.getAccountEntryId() != commerceOrder.getCommerceAccountId()) {
                commerceOrder = this._commerceOrderService.fetchCommerceOrder(accountEntry.getAccountEntryId(), commerceChannel.getGroupId(), this._portal.getUserId(httpServletRequest), 2);
            }
            if (commerceOrder != null) {
                this._validateCommerceOrderItemVersions(commerceOrder, this._portal.getLocale(httpServletRequest));
                this._setCurrentCommerceOrder(commerceOrder);
                return commerceOrder;
            }
        }
        if (Validator.isNotNull((String)commerceOrderUuid) && (commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannel.getGroupId())) != null) {
            this._setCurrentCommerceOrder(commerceOrder);
        }
        return commerceOrder;
    }

    private LayoutDisplayPageObjectProvider<?> _getLayoutDisplayPageObjectProvider(CommerceOrder commerceOrder) {
        LayoutDisplayPageProvider layoutDisplayPageProvider = this.layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByClassName(CommerceOrder.class.getName());
        InfoItemReference infoItemReference = new InfoItemReference(CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId());
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(infoItemReference);
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        if (locale == null) {
            return key;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, key);
    }

    private PortletURL _getPortletURL(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        return this._getPortletURL(groupId, httpServletRequest, portletId);
    }

    private PortletURL _getPortletURL(long groupId, HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        LiferayPortletURL portletURL = null;
        long plid = this._portal.getPlidFromPortletId(groupId, portletId);
        portletURL = plid > 0L ? this._portletURLFactory.create(httpServletRequest, portletId, plid, "RENDER_PHASE") : this._portletURLFactory.create(httpServletRequest, portletId, "RENDER_PHASE");
        return portletURL;
    }

    private void _setCurrentCommerceOrder(CommerceOrder commerceOrder) {
        _commerceOrder.set(commerceOrder);
        _initialized.set(Boolean.TRUE);
    }

    private void _setGuestCommerceOrder(CommerceOrder commerceOrder, ThemeDisplay themeDisplay) throws PortalException {
        User user = themeDisplay.getUser();
        if (user != null && !user.isGuestUser()) {
            return;
        }
        long commerceChannelGroupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(themeDisplay.getScopeGroupId());
        Cookie cookie = new Cookie(this.getCookieName(commerceChannelGroupId), commerceOrder.getUuid());
        String domain = CookiesManagerUtil.getDomain((HttpServletRequest)themeDisplay.getRequest());
        if (Validator.isNotNull((String)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(31536000);
        CookiesManagerUtil.addCookie((int)2, (Cookie)cookie, (HttpServletRequest)themeDisplay.getRequest(), (HttpServletResponse)themeDisplay.getResponse());
    }

    private void _unsetCurrentCommerceOrder() {
        _commerceOrder.remove();
        _initialized.set(Boolean.FALSE);
    }

    private void _validateCommerceOrderItemVersions(CommerceOrder commerceOrder, Locale locale) throws PortalException {
        VersionCommerceOrderValidatorImpl versionCommerceOrderValidatorImpl = new VersionCommerceOrderValidatorImpl();
        versionCommerceOrderValidatorImpl.setCommerceOrderItemLocalService(this._commerceOrderItemLocalService);
        versionCommerceOrderValidatorImpl.setCPInstanceLocalService(this._cpInstanceLocalService);
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            versionCommerceOrderValidatorImpl.validate(locale, commerceOrderItem);
        }
    }
}

