/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderTable;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderResource;
import com.liferay.object.field.builder.DateObjectFieldBuilder;
import com.liferay.object.field.builder.IntegerObjectFieldBuilder;
import com.liferay.object.field.builder.LongIntegerObjectFieldBuilder;
import com.liferay.object.field.builder.PrecisionDecimalObjectFieldBuilder;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionManager.class})
public class CommerceOrderSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private OrderResource.Factory _orderResourceFactory;

    public long addBaseModel(boolean checkPermissions, User user, Map<String, Object> values) throws Exception {
        OrderResource orderResource = this._buildOrderResource(checkPermissions, user);
        Order order = orderResource.postOrder(this._toOrder(values));
        this.setExtendedProperties(Order.class.getName(), order, user, values);
        return order.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._commerceOrderLocalService.deleteCommerceOrder((CommerceOrder)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._commerceOrderLocalService.fetchCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commerceOrderLocalService.getCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getBaseModelExternalReferenceCode(long primaryKey) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(primaryKey);
        return commerceOrder.getExternalReferenceCode();
    }

    public String getExternalReferenceCode() {
        return "L_COMMERCE_ORDER";
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Order", "headless-commerce-admin-order", "orders", "v1.0");
    }

    public Map<String, String> getLabelKeys() {
        return HashMapBuilder.put((Object)"label", (Object)"commerce-order").put((Object)"pluralLabel", (Object)"commerce-orders").build();
    }

    public Class<?> getModelClass() {
        return CommerceOrder.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new LongIntegerObjectFieldBuilder().labelMap(this.createLabelMap("account-id")).name("accountId").required(true).system(true).build(), new LongIntegerObjectFieldBuilder().labelMap(this.createLabelMap("channel-id")).name("channelId").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("currency-code")).name("currencyCode").required(true).system(true).build(), new DateObjectFieldBuilder().labelMap(this.createLabelMap("order-date")).name("orderDate").system(true).build(), new IntegerObjectFieldBuilder().labelMap(this.createLabelMap("order-status")).name("orderStatus").required(true).system(true).build(), new TextObjectFieldBuilder().dbColumnName("orderTypeExternalReferenceCode").labelMap(this.createLabelMap("order-type-external-reference-code")).name("orderTypeExternalReferenceCode").system(true).build(), new LongIntegerObjectFieldBuilder().dbColumnName("orderTypeId").labelMap(this.createLabelMap("order-type-id")).name("orderTypeId").system(true).build(), new IntegerObjectFieldBuilder().labelMap(this.createLabelMap("payment-status")).name("paymentStatus").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("payment-method-key")).name("paymentMethodKey").system(true).build(), new PrecisionDecimalObjectFieldBuilder().labelMap(this.createLabelMap("shipping-amount")).name("shippingAmount").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("formatted-shipping-amount")).name("shippingAmountFormatted").readOnly("true").build(), new PrecisionDecimalObjectFieldBuilder().labelMap(this.createLabelMap("tax-amount")).name("taxAmount").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("formatted-tax-amount")).name("taxAmountFormatted").readOnly("true").build(), new PrecisionDecimalObjectFieldBuilder().labelMap(this.createLabelMap("total")).name("total").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("formatted-total-amount")).name("totalFormatted").readOnly("true").build());
    }

    public Page<?> getPage(User user, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        OrderResource orderResource = this._buildOrderResource(true, user);
        return orderResource.getOrdersPage(search, filter, pagination, sorts);
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CommerceOrderTable.INSTANCE.commerceOrderId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CommerceOrderTable.INSTANCE;
    }

    public int getVersion() {
        return 6;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        OrderResource orderResource = this._buildOrderResource(false, user);
        orderResource.patchOrder(Long.valueOf(primaryKey), this._toOrder(values));
        this.setExtendedProperties(Order.class.getName(), JSONUtil.put((String)"id", (Object)primaryKey), user, values);
    }

    private OrderResource _buildOrderResource(boolean checkPermissions, User user) {
        OrderResource.Builder builder = this._orderResourceFactory.create();
        return builder.checkPermissions(checkPermissions).preferredLocale(user.getLocale()).user(user).build();
    }

    private Order _toOrder(final Map<String, Object> values) {
        return new Order(){
            {
                this.setAccountId(() -> GetterUtil.getLong(values.get("accountId")));
                this.setChannelId(() -> GetterUtil.getLong(values.get("channelId")));
                this.setCurrencyCode(() -> GetterUtil.getString(values.get("currencyCode")));
                this.setExternalReferenceCode(() -> GetterUtil.getString(values.get("externalReferenceCode")));
                this.setOrderDate(() -> GetterUtil.getDate(values.get("orderDate"), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss'Z'")));
                this.setOrderStatus(() -> GetterUtil.getInteger(values.get("orderStatus")));
                this.setOrderTypeExternalReferenceCode(() -> GetterUtil.getString(values.get("orderTypeExternalReferenceCode")));
                this.setOrderTypeId(() -> GetterUtil.getLong(values.get("orderTypeId")));
                this.setPaymentMethod(() -> GetterUtil.getString(values.get("paymentMethodKey")));
                this.setPaymentStatus(() -> GetterUtil.getInteger(values.get("paymentStatus")));
                this.setShippingAmount(() -> {
                    String shippingAmountString = GetterUtil.getString(values.get("shippingAmount"));
                    if (Validator.isNull((String)shippingAmountString)) {
                        return null;
                    }
                    return new BigDecimal(shippingAmountString);
                });
                this.setShippingAmountFormatted(() -> GetterUtil.getString(values.get("shippingAmountFormatted")));
                this.setTaxAmount(() -> {
                    String taxAmountString = GetterUtil.getString(values.get("taxAmount"));
                    if (Validator.isNull((String)taxAmountString)) {
                        return null;
                    }
                    return new BigDecimal(taxAmountString);
                });
                this.setTaxAmountFormatted(() -> GetterUtil.getString(values.get("taxAmountFormatted")));
                this.setTotal(() -> {
                    String totalString = GetterUtil.getString(values.get("total"));
                    if (Validator.isNull((String)totalString)) {
                        return null;
                    }
                    return new BigDecimal(totalString);
                });
                this.setTotalFormatted(() -> GetterUtil.getString(values.get("totalFormatted")));
            }
        };
    }
}

