/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.action.executor;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionExecutor.class})
public class SplitCommerceOrderByCatalogObjectActionExecutorImpl
implements ObjectActionExecutor,
ObjectDefinitionScoped {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CounterLocalService _counterLocalService;

    public void execute(long companyId, long objectActionId, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject, long userId) throws Exception {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            long commerceOrderId = payloadJSONObject.getLong("classPK");
            CommerceOrder customerCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
            if (this._isSplitted(customerCommerceOrder)) {
                return null;
            }
            Map<CommerceCatalog, List<CommerceOrderItem>> commerceCatalogCommerceOrderItemsMap = this._getCommerceCatalogCommerceOrderItemMap(customerCommerceOrder.getCommerceOrderItems());
            int numberCatalogByOrderItem = commerceCatalogCommerceOrderItemsMap.size();
            if (numberCatalogByOrderItem == 1) {
                List commerceChannels;
                Map.Entry<CommerceCatalog, List<CommerceOrderItem>> commerceCatalogCommerceOrderItems;
                CommerceCatalog commerceCatalog;
                long accountEntryId;
                Set<Map.Entry<CommerceCatalog, List<CommerceOrderItem>>> entries = commerceCatalogCommerceOrderItemsMap.entrySet();
                Iterator<Map.Entry<CommerceCatalog, List<CommerceOrderItem>>> iterator = entries.iterator();
                if (iterator.hasNext() && (accountEntryId = (commerceCatalog = (commerceCatalogCommerceOrderItems = iterator.next()).getKey()).getAccountEntryId()) > 0L && ListUtil.isNotEmpty((List)(commerceChannels = this._commerceChannelLocalService.getCommerceChannelsByAccountEntryId(accountEntryId)))) {
                    CommerceCurrency commerceCurrency = customerCommerceOrder.getCommerceCurrency();
                    RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
                    this._createSupplierOrder(customerCommerceOrder, commerceCatalogCommerceOrderItems.getValue(), (CommerceChannel)commerceChannels.get(0), roundingMode);
                }
                this._handleBookedQuantity(commerceOrderId);
            } else if (numberCatalogByOrderItem > 1) {
                this._createSupplierOrders(customerCommerceOrder, commerceCatalogCommerceOrderItemsMap);
                this._handleBookedQuantity(commerceOrderId);
            }
            return null;
        });
    }

    public List<String> getAllowedObjectDefinitionNames() {
        return Arrays.asList("CommerceOrder");
    }

    public String getKey() {
        return "split-commerce-order-by-catalog";
    }

    private void _addSupplierBookedQuantity(List<Long> supplierCommerceOrderIds) throws Exception {
        for (Long supplierCommerceOrderId : supplierCommerceOrderIds) {
            CommerceOrder supplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(supplierCommerceOrderId.longValue());
            List supplierCommerceOrderItems = supplierCommerceOrder.getCommerceOrderItems();
            AccountEntry accountEntry = supplierCommerceOrder.getAccountEntry();
            for (CommerceOrderItem commerceOrderItem : supplierCommerceOrderItems) {
                CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.addCommerceInventoryBookedQuantity(commerceOrderItem.getUserId(), null, commerceOrderItem.getQuantity(), commerceOrderItem.getSku(), "", (Map)HashMapBuilder.put((Object)"accountName", (Object)accountEntry.getName()).put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).build());
                this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId());
            }
        }
    }

    private BigDecimal _calculateSubtotalDiscountAmount(CommerceOrder customerCommerceOrder, RoundingMode roundingMode, BigDecimal subtotal) {
        BigDecimal newSubtotalDiscountAmount = BigDecimal.ZERO;
        BigDecimal customerSubtotalDiscountAmount = customerCommerceOrder.getSubtotalDiscountAmount();
        if (customerSubtotalDiscountAmount.signum() > 0) {
            BigDecimal customerCommerceOrderSubtotal = customerCommerceOrder.getSubtotal();
            newSubtotalDiscountAmount = customerSubtotalDiscountAmount.multiply(subtotal);
            newSubtotalDiscountAmount = newSubtotalDiscountAmount.divide(customerCommerceOrderSubtotal, roundingMode);
        }
        return newSubtotalDiscountAmount;
    }

    private BigDecimal _calculateTotalDiscountAmount(CommerceOrder customerCommerceOrder, RoundingMode roundingMode, BigDecimal supplierTotal) {
        BigDecimal newTotalDiscountAmount = BigDecimal.ZERO;
        BigDecimal customerTotalDiscountAmount = customerCommerceOrder.getTotalDiscountAmount();
        if (customerTotalDiscountAmount.signum() > 0) {
            BigDecimal customerCommerceOrderTotal = customerCommerceOrder.getTotal();
            newTotalDiscountAmount = customerTotalDiscountAmount.multiply(supplierTotal);
            BigDecimal add = customerCommerceOrderTotal.add(customerTotalDiscountAmount);
            newTotalDiscountAmount = newTotalDiscountAmount.divide(add, roundingMode);
        }
        return newTotalDiscountAmount;
    }

    private void _createSupplierOrder(CommerceOrder customerCommerceOrder, List<CommerceOrderItem> commerceOrderItems, CommerceChannel commerceChannel, RoundingMode roundingMode) {
        CommerceOrder supplierCommerceOrder = customerCommerceOrder.cloneWithOriginalValues();
        supplierCommerceOrder.setUuid(PortalUUIDUtil.generate());
        supplierCommerceOrder.setExternalReferenceCode(PortalUUIDUtil.generate());
        long newCommerceOrderId = this._counterLocalService.increment();
        supplierCommerceOrder.setCommerceOrderId(newCommerceOrderId);
        if (commerceChannel != null) {
            supplierCommerceOrder.setGroupId(commerceChannel.getGroupId());
        }
        supplierCommerceOrder.setManuallyAdjusted(true);
        supplierCommerceOrder.setShippingAmount(BigDecimal.ZERO);
        supplierCommerceOrder.setShippingDiscountAmount(BigDecimal.ZERO);
        BigDecimal subtotal = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            CommerceOrderItem newCommerceOrderItem = commerceOrderItem.cloneWithOriginalValues();
            newCommerceOrderItem.setUuid(PortalUUIDUtil.generate());
            newCommerceOrderItem.setExternalReferenceCode(PortalUUIDUtil.generate());
            newCommerceOrderItem.setCommerceOrderItemId(this._counterLocalService.increment());
            if (commerceChannel != null) {
                newCommerceOrderItem.setGroupId(commerceChannel.getGroupId());
            }
            newCommerceOrderItem.setCommerceInventoryBookedQuantityId(0L);
            newCommerceOrderItem.setCommerceOrderId(newCommerceOrderId);
            newCommerceOrderItem.setCustomerCommerceOrderItemId(commerceOrderItem.getCommerceOrderItemId());
            newCommerceOrderItem.setParentCommerceOrderItemId(0L);
            newCommerceOrderItem.setDiscountManuallyAdjusted(true);
            newCommerceOrderItem.setManuallyAdjusted(true);
            newCommerceOrderItem.setPriceManuallyAdjusted(true);
            newCommerceOrderItem.setUnitOfMeasureIncrementalOrderQuantity(commerceOrderItem.getUnitOfMeasureIncrementalOrderQuantity());
            newCommerceOrderItem.setUnitOfMeasureKey(commerceOrderItem.getUnitOfMeasureKey());
            this._commerceOrderItemLocalService.addCommerceOrderItem(newCommerceOrderItem);
            BigDecimal finalPrice = newCommerceOrderItem.getFinalPrice();
            subtotal = subtotal.add(finalPrice);
            BigDecimal finalPriceWithTaxAmount = newCommerceOrderItem.getFinalPriceWithTaxAmount();
            BigDecimal tax = finalPriceWithTaxAmount.subtract(finalPrice);
            taxAmount = taxAmount.add(tax);
        }
        supplierCommerceOrder.setSubtotal(subtotal);
        BigDecimal newSubtotalDiscountAmount = this._calculateSubtotalDiscountAmount(customerCommerceOrder, roundingMode, subtotal);
        supplierCommerceOrder.setSubtotalDiscountAmount(newSubtotalDiscountAmount);
        supplierCommerceOrder.setTaxAmount(taxAmount);
        BigDecimal supplierTotal = subtotal.add(taxAmount);
        BigDecimal newTotalDiscountAmount = this._calculateTotalDiscountAmount(customerCommerceOrder, roundingMode, supplierTotal);
        supplierCommerceOrder.setTotalDiscountAmount(newTotalDiscountAmount);
        supplierTotal = supplierTotal.subtract(newSubtotalDiscountAmount);
        supplierTotal = supplierTotal.subtract(newTotalDiscountAmount);
        supplierCommerceOrder.setTotal(supplierTotal);
        this._commerceOrderLocalService.addCommerceOrder(supplierCommerceOrder);
    }

    private void _createSupplierOrders(CommerceOrder customerCommerceOrder, Map<CommerceCatalog, List<CommerceOrderItem>> commerceCatalogCommerceOrderItemsMap) throws Exception {
        CommerceCurrency commerceCurrency = customerCommerceOrder.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        commerceCatalogCommerceOrderItemsMap.forEach((commerceCatalog, commerceOrderItems) -> {
            List commerceChannels;
            long accountEntryId = commerceCatalog.getAccountEntryId();
            CommerceChannel commerceChannel = null;
            if (accountEntryId > 0L && ListUtil.isNotEmpty((List)(commerceChannels = this._commerceChannelLocalService.getCommerceChannelsByAccountEntryId(accountEntryId)))) {
                commerceChannel = (CommerceChannel)commerceChannels.get(0);
            }
            this._createSupplierOrder(customerCommerceOrder, (List<CommerceOrderItem>)commerceOrderItems, commerceChannel, roundingMode);
        });
    }

    private Map<CommerceCatalog, List<CommerceOrderItem>> _getCommerceCatalogCommerceOrderItemMap(List<CommerceOrderItem> commerceOrderItems) {
        HashMap<CommerceCatalog, List<CommerceOrderItem>> commerceCatalogCommerceOrderItemsMap = new HashMap<CommerceCatalog, List<CommerceOrderItem>>();
        ListUtil.isNotEmptyForEach(commerceOrderItems, commerceOrderItem -> {
            try {
                CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
                CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
                if (commerceCatalogCommerceOrderItemsMap.containsKey(commerceCatalog)) {
                    List splitCommerceOrderItems = (List)commerceCatalogCommerceOrderItemsMap.get(commerceCatalog);
                    splitCommerceOrderItems.add(commerceOrderItem);
                    commerceCatalogCommerceOrderItemsMap.put(commerceCatalog, splitCommerceOrderItems);
                } else {
                    commerceCatalogCommerceOrderItemsMap.put(commerceCatalog, ListUtil.toList((Object)commerceOrderItem));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
        return commerceCatalogCommerceOrderItemsMap;
    }

    private void _handleBookedQuantity(long commerceOrderId) throws Exception {
        CommerceOrder customerCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        this._releaseCustomerBookedQuantity(customerCommerceOrder.getCommerceOrderItems());
        this._addSupplierBookedQuantity(customerCommerceOrder.getSupplierCommerceOrderIds());
    }

    private boolean _isSplitted(CommerceOrder customerCommerceOrder) {
        int supplierCommerceOrderIdsCount = customerCommerceOrder.getSupplierCommerceOrderIdsCount();
        int customerCommerceOrderIdsCount = customerCommerceOrder.getCustomerCommerceOrderIdsCount();
        return supplierCommerceOrderIdsCount > 0 || customerCommerceOrderIdsCount > 0;
    }

    private void _releaseCustomerBookedQuantity(List<CommerceOrderItem> commerceOrderItems) throws Exception {
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this._commerceInventoryBookedQuantityLocalService.deleteCommerceInventoryBookedQuantity(commerceOrderItem.getCommerceInventoryBookedQuantityId());
            commerceOrderItem.setCommerceInventoryBookedQuantityId(0L);
            this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
        }
    }
}

