/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.notification.term.evaluator;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class CommerceOrderPaymentMethodNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    private final ObjectDefinition _objectDefinition;
    private final UserLocalService _userLocalService;

    public CommerceOrderPaymentMethodNotificationTermEvaluator(CommerceOrderLocalService commerceOrderLocalService, CommercePaymentMethodGroupRelLocalService commercePaymentMethodGroupRelLocalService, ObjectDefinition objectDefinition, UserLocalService userLocalService) {
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._commercePaymentMethodGroupRelLocalService = commercePaymentMethodGroupRelLocalService;
        this._objectDefinition = objectDefinition;
        this._userLocalService = userLocalService;
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map && termName.equals("[%COMMERCEORDER_PAYMENT_METHOD_NAME%]") && "CommerceOrder".equalsIgnoreCase(this._objectDefinition.getShortName()))) {
            return termName;
        }
        Map termValues = (Map)object;
        return this._getPaymentMethodName(termValues);
    }

    private String _getPaymentMethodName(Map<String, Object> termValues) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(GetterUtil.getLong((Object)termValues.get("id")));
        String paymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (Validator.isNull((String)paymentMethodKey)) {
            return null;
        }
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), paymentMethodKey);
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        return commercePaymentMethodGroupRel.getName(user.getLocale());
    }
}

