/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.helper;

import com.liferay.commerce.helper.CommerceShippingHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.Dimensions;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(service={CommerceShippingHelper.class})
public class CommerceShippingHelperImpl
implements CommerceShippingHelper {
    public Dimensions getDimensions(CommerceOrderItem commerceOrderItem) {
        if (commerceOrderItem == null) {
            return new Dimensions(0.0, 0.0, 0.0);
        }
        return new Dimensions(commerceOrderItem.getWidth(), commerceOrderItem.getHeight(), commerceOrderItem.getDepth());
    }

    public Dimensions getDimensions(CPInstance cpInstance) {
        if (cpInstance == null) {
            return new Dimensions(0.0, 0.0, 0.0);
        }
        return new Dimensions(cpInstance.getWidth(), cpInstance.getHeight(), cpInstance.getDepth());
    }

    public Dimensions getDimensions(List<CommerceOrderItem> commerceOrderItems) throws PortalException {
        double width;
        CommerceOrderItem commerceOrderItem;
        if (commerceOrderItems.size() == 1 && BigDecimalUtil.eq((BigDecimal)(commerceOrderItem = commerceOrderItems.get(0)).getQuantity(), (BigDecimal)BigDecimal.ONE)) {
            return this.getDimensions(commerceOrderItem);
        }
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        double maxDepth = 0.0;
        double volume = 0.0;
        for (CommerceOrderItem commerceOrderItem2 : commerceOrderItems) {
            if (!commerceOrderItem2.isShippable() || commerceOrderItem2.isFreeShipping()) continue;
            Dimensions dimensions = this.getDimensions(commerceOrderItem2);
            double width2 = dimensions.getWidth();
            double height = dimensions.getHeight();
            double depth = dimensions.getDepth();
            maxWidth = Math.max(maxWidth, width2);
            maxHeight = Math.max(maxHeight, height);
            maxDepth = Math.max(maxDepth, depth);
            BigDecimal quantity = commerceOrderItem2.getQuantity();
            volume += width2 * height * depth * (double)quantity.intValue();
        }
        double height = width = Math.cbrt(volume);
        double depth = width;
        width = Math.max(maxWidth, width);
        height = Math.max(maxHeight, height);
        depth = Math.max(maxDepth, depth);
        return new Dimensions(width, height, depth);
    }

    public double getWeight(CommerceOrderItem commerceOrderItem) {
        if (commerceOrderItem == null) {
            return 0.0;
        }
        return commerceOrderItem.getWeight();
    }

    public double getWeight(CPInstance cpInstance) {
        if (cpInstance == null) {
            return 0.0;
        }
        return cpInstance.getWeight();
    }

    public double getWeight(List<CommerceOrderItem> commerceOrderItems) throws PortalException {
        double weight = 0.0;
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (!commerceOrderItem.isShippable() || commerceOrderItem.isFreeShipping()) continue;
            BigDecimal quantity = commerceOrderItem.getQuantity();
            weight += this.getWeight(commerceOrderItem) * (double)quantity.intValue();
        }
        return weight;
    }

    public boolean isFreeShipping(CommerceOrder commerceOrder) throws PortalException {
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            if (commerceOrderItem.isFreeShipping()) continue;
            return false;
        }
        return true;
    }

    public boolean isShippable(CommerceOrder commerceOrder) throws PortalException {
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            if (!commerceOrderItem.isShippable()) continue;
            return true;
        }
        return false;
    }
}

