/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.events;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import jakarta.portlet.PortletURL;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class CommerceCheckoutPreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(CommerceCheckoutPreAction.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block4: {
            try {
                PortletURL commerceCheckoutPortletURL;
                CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
                if (commerceChannel == null) {
                    return;
                }
                HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
                HttpSession httpSession = originalHttpServletRequest.getSession();
                CommerceOrder commerceOrder = (CommerceOrder)httpSession.getAttribute("COMMERCE_ORDER_ON_ACCOUNT_SELECTION");
                boolean immediateCheckout = GetterUtil.getBoolean((Object)httpSession.getAttribute("#immediate-checkout"));
                if (commerceOrder == null && immediateCheckout && (commerceCheckoutPortletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (Group)this._groupLocalService.getGroup(commerceChannel.getSiteGroupId()), (String)"com_liferay_commerce_checkout_web_internal_portlet_CommerceCheckoutPortlet", (PortletProvider.Action)PortletProvider.Action.VIEW)) != null) {
                    httpSession.removeAttribute("#immediate-checkout");
                    httpServletResponse.sendRedirect(PortletURLBuilder.create((PortletURL)commerceCheckoutPortletURL).setMVCRenderCommandName("/commerce_checkout/checkout_redirect").buildString());
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
    }
}

