/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchOrderTypeException;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.commerce.model.impl.CommerceOrderTypeImpl;
import com.liferay.commerce.model.impl.CommerceOrderTypeModelImpl;
import com.liferay.commerce.service.persistence.CommerceOrderTypePersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CommerceOrderTypePersistenceImpl
extends BasePersistenceImpl<CommerceOrderType>
implements CommerceOrderTypePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceOrderTypeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "commerceOrderType.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByLtD_S;
    private FinderPath _finderPathWithPaginationCountByLtD_S;
    private static final String _FINDER_COLUMN_LTD_S_DISPLAYDATE_1 = "commerceOrderType.displayDate IS NULL AND ";
    private static final String _FINDER_COLUMN_LTD_S_DISPLAYDATE_2 = "commerceOrderType.displayDate < ? AND ";
    private static final String _FINDER_COLUMN_LTD_S_STATUS_2 = "commerceOrderType.status = ?";
    private FinderPath _finderPathWithPaginationFindByLtE_S;
    private FinderPath _finderPathWithPaginationCountByLtE_S;
    private static final String _FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1 = "commerceOrderType.expirationDate IS NULL AND ";
    private static final String _FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2 = "commerceOrderType.expirationDate < ? AND ";
    private static final String _FINDER_COLUMN_LTE_S_STATUS_2 = "commerceOrderType.status = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "commerceOrderType.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "commerceOrderType.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(commerceOrderType.externalReferenceCode IS NULL OR commerceOrderType.externalReferenceCode = '')";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEORDERTYPE = "SELECT commerceOrderType FROM CommerceOrderType commerceOrderType";
    private static final String _SQL_SELECT_COMMERCEORDERTYPE_WHERE = "SELECT commerceOrderType FROM CommerceOrderType commerceOrderType WHERE ";
    private static final String _SQL_COUNT_COMMERCEORDERTYPE = "SELECT COUNT(commerceOrderType) FROM CommerceOrderType commerceOrderType";
    private static final String _SQL_COUNT_COMMERCEORDERTYPE_WHERE = "SELECT COUNT(commerceOrderType) FROM CommerceOrderType commerceOrderType WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "commerceOrderType.commerceOrderTypeId";
    private static final String _FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE = "SELECT DISTINCT {commerceOrderType.*} FROM CommerceOrderType commerceOrderType WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {CommerceOrderType.*} FROM (SELECT DISTINCT commerceOrderType.commerceOrderTypeId FROM CommerceOrderType commerceOrderType WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN CommerceOrderType ON TEMP_TABLE.commerceOrderTypeId = CommerceOrderType.commerceOrderTypeId";
    private static final String _FILTER_SQL_COUNT_COMMERCEORDERTYPE_WHERE = "SELECT COUNT(DISTINCT commerceOrderType.commerceOrderTypeId) AS COUNT_VALUE FROM CommerceOrderType commerceOrderType WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "commerceOrderType";
    private static final String _FILTER_ENTITY_TABLE = "CommerceOrderType";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceOrderType.";
    private static final String _ORDER_BY_ENTITY_TABLE = "CommerceOrderType.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceOrderType exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceOrderType exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderTypePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"active"});

    public List<CommerceOrderType> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceOrderType> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CommerceOrderType> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderType> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CommerceOrderType commerceOrderType : list) {
                if (companyId == commerceOrderType.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderType.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderType findByCompanyId_First(long companyId, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (commerceOrderType != null) {
            return commerceOrderType;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOrderTypeException(sb.toString());
    }

    public CommerceOrderType fetchByCompanyId_First(long companyId, OrderByComparator<CommerceOrderType> orderByComparator) {
        List<CommerceOrderType> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderType findByCompanyId_Last(long companyId, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (commerceOrderType != null) {
            return commerceOrderType;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOrderTypeException(sb.toString());
    }

    public CommerceOrderType fetchByCompanyId_Last(long companyId, OrderByComparator<CommerceOrderType> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderType> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderType[] findByCompanyId_PrevAndNext(long commerceOrderTypeId, long companyId, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.findByPrimaryKey(commerceOrderTypeId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType[] array = new CommerceOrderTypeImpl[]{this.getByCompanyId_PrevAndNext(session, commerceOrderType, companyId, orderByComparator, true), commerceOrderType, this.getByCompanyId_PrevAndNext(session, commerceOrderType, companyId, orderByComparator, false)};
            CommerceOrderType[] commerceOrderTypeArray = array;
            return commerceOrderTypeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType getByCompanyId_PrevAndNext(Session session, CommerceOrderType commerceOrderType, long companyId, OrderByComparator<CommerceOrderType> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderType)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderType)list.get(1);
        }
        return null;
    }

    public List<CommerceOrderType> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceOrderType> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<CommerceOrderType> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceOrderType.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceOrderTypeImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceOrderTypeImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceOrderType[] filterFindByCompanyId_PrevAndNext(long commerceOrderTypeId, long companyId, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(commerceOrderTypeId, companyId, orderByComparator);
        }
        CommerceOrderType commerceOrderType = this.findByPrimaryKey(commerceOrderTypeId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType[] array = new CommerceOrderTypeImpl[]{this.filterGetByCompanyId_PrevAndNext(session, commerceOrderType, companyId, orderByComparator, true), commerceOrderType, this.filterGetByCompanyId_PrevAndNext(session, commerceOrderType, companyId, orderByComparator, false)};
            CommerceOrderType[] commerceOrderTypeArray = array;
            return commerceOrderTypeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType filterGetByCompanyId_PrevAndNext(Session session, CommerceOrderType commerceOrderType, long companyId, OrderByComparator<CommerceOrderType> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceOrderType.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceOrderTypeImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceOrderTypeImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderType)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceOrderType)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CommerceOrderType commerceOrderType : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderType);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceOrderType> findByLtD_S(Date displayDate, int status) {
        return this.findByLtD_S(displayDate, status, -1, -1, null);
    }

    public List<CommerceOrderType> findByLtD_S(Date displayDate, int status, int start, int end) {
        return this.findByLtD_S(displayDate, status, start, end, null);
    }

    public List<CommerceOrderType> findByLtD_S(Date displayDate, int status, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        return this.findByLtD_S(displayDate, status, start, end, orderByComparator, true);
    }

    public List<CommerceOrderType> findByLtD_S(Date displayDate, int status, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtD_S;
        finderArgs = new Object[]{CommerceOrderTypePersistenceImpl._getTime(displayDate), status, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CommerceOrderType commerceOrderType : list) {
                if (displayDate.getTime() > commerceOrderType.getDisplayDate().getTime() && status == commerceOrderType.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
            boolean bindDisplayDate = false;
            if (displayDate == null) {
                sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_1);
            } else {
                bindDisplayDate = true;
                sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_2);
            }
            sb.append("commerceOrderType.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderType.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindDisplayDate) {
                    queryPos.add(new Timestamp(displayDate.getTime()));
                }
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderType findByLtD_S_First(Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByLtD_S_First(displayDate, status, orderByComparator);
        if (commerceOrderType != null) {
            return commerceOrderType;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("displayDate<");
        sb.append((Object)displayDate);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchOrderTypeException(sb.toString());
    }

    public CommerceOrderType fetchByLtD_S_First(Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) {
        List<CommerceOrderType> list = this.findByLtD_S(displayDate, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderType findByLtD_S_Last(Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByLtD_S_Last(displayDate, status, orderByComparator);
        if (commerceOrderType != null) {
            return commerceOrderType;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("displayDate<");
        sb.append((Object)displayDate);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchOrderTypeException(sb.toString());
    }

    public CommerceOrderType fetchByLtD_S_Last(Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) {
        int count = this.countByLtD_S(displayDate, status);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderType> list = this.findByLtD_S(displayDate, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderType[] findByLtD_S_PrevAndNext(long commerceOrderTypeId, Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.findByPrimaryKey(commerceOrderTypeId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType[] array = new CommerceOrderTypeImpl[]{this.getByLtD_S_PrevAndNext(session, commerceOrderType, displayDate, status, orderByComparator, true), commerceOrderType, this.getByLtD_S_PrevAndNext(session, commerceOrderType, displayDate, status, orderByComparator, false)};
            CommerceOrderType[] commerceOrderTypeArray = array;
            return commerceOrderTypeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType getByLtD_S_PrevAndNext(Session session, CommerceOrderType commerceOrderType, Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        boolean bindDisplayDate = false;
        if (displayDate == null) {
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_1);
        } else {
            bindDisplayDate = true;
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindDisplayDate) {
            queryPos.add(new Timestamp(displayDate.getTime()));
        }
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderType)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderType)list.get(1);
        }
        return null;
    }

    public List<CommerceOrderType> filterFindByLtD_S(Date displayDate, int status) {
        return this.filterFindByLtD_S(displayDate, status, -1, -1, null);
    }

    public List<CommerceOrderType> filterFindByLtD_S(Date displayDate, int status, int start, int end) {
        return this.filterFindByLtD_S(displayDate, status, start, end, null);
    }

    public List<CommerceOrderType> filterFindByLtD_S(Date displayDate, int status, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByLtD_S(displayDate, status, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindDisplayDate = false;
        if (displayDate == null) {
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_1);
        } else {
            bindDisplayDate = true;
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceOrderType.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceOrderTypeImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceOrderTypeImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindDisplayDate) {
                queryPos.add(new Timestamp(displayDate.getTime()));
            }
            queryPos.add(status);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceOrderType[] filterFindByLtD_S_PrevAndNext(long commerceOrderTypeId, Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByLtD_S_PrevAndNext(commerceOrderTypeId, displayDate, status, orderByComparator);
        }
        CommerceOrderType commerceOrderType = this.findByPrimaryKey(commerceOrderTypeId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType[] array = new CommerceOrderTypeImpl[]{this.filterGetByLtD_S_PrevAndNext(session, commerceOrderType, displayDate, status, orderByComparator, true), commerceOrderType, this.filterGetByLtD_S_PrevAndNext(session, commerceOrderType, displayDate, status, orderByComparator, false)};
            CommerceOrderType[] commerceOrderTypeArray = array;
            return commerceOrderTypeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType filterGetByLtD_S_PrevAndNext(Session session, CommerceOrderType commerceOrderType, Date displayDate, int status, OrderByComparator<CommerceOrderType> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindDisplayDate = false;
        if (displayDate == null) {
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_1);
        } else {
            bindDisplayDate = true;
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceOrderType.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceOrderTypeImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceOrderTypeImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        if (bindDisplayDate) {
            queryPos.add(new Timestamp(displayDate.getTime()));
        }
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderType)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceOrderType)list.get(1);
        }
        return null;
    }

    public void removeByLtD_S(Date displayDate, int status) {
        for (CommerceOrderType commerceOrderType : this.findByLtD_S(displayDate, status, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderType);
        }
    }

    public int countByLtD_S(Date displayDate, int status) {
        FinderPath finderPath = this._finderPathWithPaginationCountByLtD_S;
        Object[] finderArgs = new Object[]{CommerceOrderTypePersistenceImpl._getTime(displayDate), status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
            boolean bindDisplayDate = false;
            if (displayDate == null) {
                sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_1);
            } else {
                bindDisplayDate = true;
                sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_2);
            }
            sb.append("commerceOrderType.status = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindDisplayDate) {
                    queryPos.add(new Timestamp(displayDate.getTime()));
                }
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByLtD_S(Date displayDate, int status) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByLtD_S(displayDate, status);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
        boolean bindDisplayDate = false;
        if (displayDate == null) {
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_1);
        } else {
            bindDisplayDate = true;
            sb.append(_FINDER_COLUMN_LTD_S_DISPLAYDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindDisplayDate) {
                queryPos.add(new Timestamp(displayDate.getTime()));
            }
            queryPos.add(status);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceOrderType> findByLtE_S(Date expirationDate, int status) {
        return this.findByLtE_S(expirationDate, status, -1, -1, null);
    }

    public List<CommerceOrderType> findByLtE_S(Date expirationDate, int status, int start, int end) {
        return this.findByLtE_S(expirationDate, status, start, end, null);
    }

    public List<CommerceOrderType> findByLtE_S(Date expirationDate, int status, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        return this.findByLtE_S(expirationDate, status, start, end, orderByComparator, true);
    }

    public List<CommerceOrderType> findByLtE_S(Date expirationDate, int status, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtE_S;
        finderArgs = new Object[]{CommerceOrderTypePersistenceImpl._getTime(expirationDate), status, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CommerceOrderType commerceOrderType : list) {
                if (expirationDate.getTime() > commerceOrderType.getExpirationDate().getTime() && status == commerceOrderType.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2);
            }
            sb.append("commerceOrderType.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderType.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderType findByLtE_S_First(Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByLtE_S_First(expirationDate, status, orderByComparator);
        if (commerceOrderType != null) {
            return commerceOrderType;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchOrderTypeException(sb.toString());
    }

    public CommerceOrderType fetchByLtE_S_First(Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) {
        List<CommerceOrderType> list = this.findByLtE_S(expirationDate, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderType findByLtE_S_Last(Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByLtE_S_Last(expirationDate, status, orderByComparator);
        if (commerceOrderType != null) {
            return commerceOrderType;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchOrderTypeException(sb.toString());
    }

    public CommerceOrderType fetchByLtE_S_Last(Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) {
        int count = this.countByLtE_S(expirationDate, status);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderType> list = this.findByLtE_S(expirationDate, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderType[] findByLtE_S_PrevAndNext(long commerceOrderTypeId, Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.findByPrimaryKey(commerceOrderTypeId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType[] array = new CommerceOrderTypeImpl[]{this.getByLtE_S_PrevAndNext(session, commerceOrderType, expirationDate, status, orderByComparator, true), commerceOrderType, this.getByLtE_S_PrevAndNext(session, commerceOrderType, expirationDate, status, orderByComparator, false)};
            CommerceOrderType[] commerceOrderTypeArray = array;
            return commerceOrderTypeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType getByLtE_S_PrevAndNext(Session session, CommerceOrderType commerceOrderType, Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindExpirationDate) {
            queryPos.add(new Timestamp(expirationDate.getTime()));
        }
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderType)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderType)list.get(1);
        }
        return null;
    }

    public List<CommerceOrderType> filterFindByLtE_S(Date expirationDate, int status) {
        return this.filterFindByLtE_S(expirationDate, status, -1, -1, null);
    }

    public List<CommerceOrderType> filterFindByLtE_S(Date expirationDate, int status, int start, int end) {
        return this.filterFindByLtE_S(expirationDate, status, start, end, null);
    }

    public List<CommerceOrderType> filterFindByLtE_S(Date expirationDate, int status, int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByLtE_S(expirationDate, status, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceOrderType.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceOrderTypeImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceOrderTypeImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindExpirationDate) {
                queryPos.add(new Timestamp(expirationDate.getTime()));
            }
            queryPos.add(status);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceOrderType[] filterFindByLtE_S_PrevAndNext(long commerceOrderTypeId, Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator) throws NoSuchOrderTypeException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByLtE_S_PrevAndNext(commerceOrderTypeId, expirationDate, status, orderByComparator);
        }
        CommerceOrderType commerceOrderType = this.findByPrimaryKey(commerceOrderTypeId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType[] array = new CommerceOrderTypeImpl[]{this.filterGetByLtE_S_PrevAndNext(session, commerceOrderType, expirationDate, status, orderByComparator, true), commerceOrderType, this.filterGetByLtE_S_PrevAndNext(session, commerceOrderType, expirationDate, status, orderByComparator, false)};
            CommerceOrderType[] commerceOrderTypeArray = array;
            return commerceOrderTypeArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType filterGetByLtE_S_PrevAndNext(Session session, CommerceOrderType commerceOrderType, Date expirationDate, int status, OrderByComparator<CommerceOrderType> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEORDERTYPE_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceOrderType.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceOrderType.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceOrderTypeImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceOrderTypeImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        if (bindExpirationDate) {
            queryPos.add(new Timestamp(expirationDate.getTime()));
        }
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderType)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceOrderType)list.get(1);
        }
        return null;
    }

    public void removeByLtE_S(Date expirationDate, int status) {
        for (CommerceOrderType commerceOrderType : this.findByLtE_S(expirationDate, status, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderType);
        }
    }

    public int countByLtE_S(Date expirationDate, int status) {
        FinderPath finderPath = this._finderPathWithPaginationCountByLtE_S;
        Object[] finderArgs = new Object[]{CommerceOrderTypePersistenceImpl._getTime(expirationDate), status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2);
            }
            sb.append("commerceOrderType.status = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByLtE_S(Date expirationDate, int status) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByLtE_S(expirationDate, status);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTE_S_EXPIRATIONDATE_2);
        }
        sb.append("commerceOrderType.status = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceOrderType.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindExpirationDate) {
                queryPos.add(new Timestamp(expirationDate.getTime()));
            }
            queryPos.add(status);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceOrderType findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceOrderType == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOrderTypeException(sb.toString());
        }
        return commerceOrderType;
    }

    public CommerceOrderType fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CommerceOrderType fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CommerceOrderType commerceOrderType;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs);
        }
        if (result instanceof CommerceOrderType && (companyId != (commerceOrderType = (CommerceOrderType)result).getCompanyId() || !Objects.equals(externalReferenceCode, commerceOrderType.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERTYPE_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CommerceOrderTypePersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceOrderType commerceOrderType2 = (CommerceOrderType)list.get(0);
                    result = commerceOrderType2;
                    this.cacheResult(commerceOrderType2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceOrderType)result;
    }

    public CommerceOrderType removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = this.findByC_ERC(companyId, externalReferenceCode);
        return (CommerceOrderType)this.remove((BaseModel)commerceOrderType);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERTYPE_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderTypePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceOrderType.class);
        this.setModelImplClass(CommerceOrderTypeImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceOrderTypeTable.INSTANCE);
    }

    public void cacheResult(CommerceOrderType commerceOrderType) {
        this.entityCache.putResult(CommerceOrderTypeImpl.class, (Serializable)Long.valueOf(commerceOrderType.getPrimaryKey()), (Serializable)commerceOrderType);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{commerceOrderType.getCompanyId(), commerceOrderType.getExternalReferenceCode()}, (Object)commerceOrderType);
    }

    public void cacheResult(List<CommerceOrderType> commerceOrderTypes) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && commerceOrderTypes.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CommerceOrderType commerceOrderType : commerceOrderTypes) {
            if (this.entityCache.getResult(CommerceOrderTypeImpl.class, (Serializable)Long.valueOf(commerceOrderType.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceOrderType);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceOrderTypeImpl.class);
        this.finderCache.clearCache(CommerceOrderTypeImpl.class);
    }

    public void clearCache(CommerceOrderType commerceOrderType) {
        this.entityCache.removeResult(CommerceOrderTypeImpl.class, (BaseModel)commerceOrderType);
    }

    public void clearCache(List<CommerceOrderType> commerceOrderTypes) {
        for (CommerceOrderType commerceOrderType : commerceOrderTypes) {
            this.entityCache.removeResult(CommerceOrderTypeImpl.class, (BaseModel)commerceOrderType);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CommerceOrderTypeImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceOrderTypeImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceOrderTypeModelImpl commerceOrderTypeModelImpl) {
        Object[] args = new Object[]{commerceOrderTypeModelImpl.getCompanyId(), commerceOrderTypeModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)commerceOrderTypeModelImpl);
    }

    public CommerceOrderType create(long commerceOrderTypeId) {
        CommerceOrderTypeImpl commerceOrderType = new CommerceOrderTypeImpl();
        commerceOrderType.setNew(true);
        commerceOrderType.setPrimaryKey(commerceOrderTypeId);
        commerceOrderType.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceOrderType;
    }

    public CommerceOrderType remove(long commerceOrderTypeId) throws NoSuchOrderTypeException {
        return this.remove(Long.valueOf(commerceOrderTypeId));
    }

    public CommerceOrderType remove(Serializable primaryKey) throws NoSuchOrderTypeException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderType commerceOrderType = (CommerceOrderType)session.get(CommerceOrderTypeImpl.class, primaryKey);
            if (commerceOrderType == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderTypeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceOrderType commerceOrderType2 = (CommerceOrderType)this.remove((BaseModel)commerceOrderType);
            return commerceOrderType2;
        }
        catch (NoSuchOrderTypeException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderType removeImpl(CommerceOrderType commerceOrderType) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceOrderType)) {
                commerceOrderType = (CommerceOrderType)session.get(CommerceOrderTypeImpl.class, commerceOrderType.getPrimaryKeyObj());
            }
            if (commerceOrderType != null) {
                session.delete((Object)commerceOrderType);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceOrderType != null) {
            this.clearCache(commerceOrderType);
        }
        return commerceOrderType;
    }

    public CommerceOrderType updateImpl(CommerceOrderType commerceOrderType) {
        boolean isNew = commerceOrderType.isNew();
        if (!(commerceOrderType instanceof CommerceOrderTypeModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceOrderType.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceOrderType);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceOrderType proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceOrderType implementation " + commerceOrderType.getClass());
        }
        CommerceOrderTypeModelImpl commerceOrderTypeModelImpl = (CommerceOrderTypeModelImpl)commerceOrderType;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceOrderType.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceOrderType.setCreateDate(date);
            } else {
                commerceOrderType.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceOrderTypeModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceOrderType.setModifiedDate(date);
            } else {
                commerceOrderType.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceOrderType);
            } else {
                commerceOrderType = (CommerceOrderType)session.merge((Object)commerceOrderType);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceOrderTypeImpl.class, (BaseModel)commerceOrderTypeModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceOrderTypeModelImpl);
        if (isNew) {
            commerceOrderType.setNew(false);
        }
        commerceOrderType.resetOriginalValues();
        return commerceOrderType;
    }

    public CommerceOrderType findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderTypeException {
        CommerceOrderType commerceOrderType = (CommerceOrderType)this.fetchByPrimaryKey(primaryKey);
        if (commerceOrderType == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderTypeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceOrderType;
    }

    public CommerceOrderType findByPrimaryKey(long commerceOrderTypeId) throws NoSuchOrderTypeException {
        return this.findByPrimaryKey(Long.valueOf(commerceOrderTypeId));
    }

    public CommerceOrderType fetchByPrimaryKey(long commerceOrderTypeId) {
        return (CommerceOrderType)this.fetchByPrimaryKey(Long.valueOf(commerceOrderTypeId));
    }

    public List<CommerceOrderType> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceOrderType> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceOrderType> findAll(int start, int end, OrderByComparator<CommerceOrderType> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceOrderType> findAll(int start, int end, OrderByComparator<CommerceOrderType> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCEORDERTYPE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEORDERTYPE;
                sql = sql.concat(" ORDER BY commerceOrderType.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceOrderType commerceOrderType : this.findAll()) {
            this.remove((BaseModel)commerceOrderType);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCEORDERTYPE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceOrderTypeId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCEORDERTYPE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceOrderTypeModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByLtD_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtD_S", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"displayDate", "status"}, true);
        this._finderPathWithPaginationCountByLtD_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtD_S", new String[]{Date.class.getName(), Integer.class.getName()}, new String[]{"displayDate", "status"}, false);
        this._finderPathWithPaginationFindByLtE_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtE_S", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"expirationDate", "status"}, true);
        this._finderPathWithPaginationCountByLtE_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtE_S", new String[]{Date.class.getName(), Integer.class.getName()}, new String[]{"expirationDate", "status"}, false);
        this._finderPathFetchByC_ERC = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, true);
        this._finderPathCountByC_ERC = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceOrderTypeImpl.class.getName());
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

